<?php
#
#   FILE:  SPT--SelectEditUserList.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("Axis--UserFactory.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to print the index value
function PrintIndex()
{
    global $Index;

    print $Index;
}

# functon to print Edit User Link 
function PrintEditUserLink()
{
    global $FoundUserArray;

    $UserName = $FoundUserArray["UserName"];
    print "SPT--EditUser.php?F_UserName=$UserName";
}

# functon to print the User Description 
function PrintUserName()
{
    global $FoundUserArray;

    $UserName = $FoundUserArray["UserName"];
    print GetHtmlEscapedString($UserName);
}

function PrintRealName()
{
    global $FoundUserArray;
    
    $RealName = $FoundUserArray["RealName"];
    print GetHtmlEscapedString($RealName);
}

function PrintEMail()
{
    global $FoundUserArray;
    
    $EMail = $FoundUserArray["EMail"];
    print GetHtmlEscapedString($EMail);
}

function PrintLastLoginDate()
{
    global $FoundUserArray;

    $LastLoginDate = $FoundUserArray["LastLoginDate"];
    print GetHtmlEscapedString($LastLoginDate);
}

function PrintAddress()
{
    global $FoundUserArray;

    $Address = $FoundUserArray["AddressLineOne"];
    print GetHtmlEscapedString($Address);
}

function PrintCity()
{
    global $FoundUserArray;

    $City = $FoundUserArray["City"];
    print GetHtmlEscapedString($City);
}

function PrintState()
{
    global $FoundUserArray;

    $State = $FoundUserArray["State"];
    print GetHtmlEscapedString($State);
}

function PrintZipCode()
{
    global $FoundUserArray;

    $ZipCode = $FoundUserArray["ZipCode"];
    print GetHtmlEscapedString($ZipCode);
}

function PrintCountry()
{
    global $FoundUserArray;

    $Country = $FoundUserArray["Country"];
    print GetHtmlEscapedString($Country);
}

# function to print the UserId 
function PrintUserId()
{
    global $FoundUserArray;

    print $FoundUserArray["UserId"];
}

# function to return if any enabled option list fields exist
function UsersExist()
{
    global $UserArray;

    return count($UserArray);
}

# function to print number of users found 
function PrintUsersFound()
{
    global $UserArray;

    print count($UserArray);
}

# display controlled name lists for editing
function DisplayUserList()
{
    global $Session;
    global $UserArray;
    global $Index;
    global $FoundUserArray;
    global $DB;

    PrintBegin();

    $Index = 0;
    foreach($UserArray as $UserId => $FoundUserArray)
    {
        DisplayUser();
        $Index++;
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN);

$UFactory = & new UserFactory($Session);

if($HTTP_POST_VARS["Submit"] == "Search for User(s)")
{
    if(!empty($HTTP_POST_VARS["F_SearchText"]))
    {
        $UserArray = $UFactory->GetMatchingUsers(
            $HTTP_POST_VARS["F_SearchText"],
            $HTTP_POST_VARS["F_SearchField"]);
    }
    else
    {
        PrintAutoRefreshPage("Select User Account to Edit", 
                            "SPT--SelectEditUser.php");
        exit;
    }
}
# return all users
else if($HTTP_POST_VARS["Submit"] == "Return All Users")
{
    $UserArray = $UFactory->GetMatchingUsers(".*.");
}

PageTitle("Edit/Delete Selected User(s)");

include("include/SPT--StandardHtmlPageLoad.php");

?>
