<?PHP
#
#   FILE:  SPT--SysStyleComplete.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       (see $FieldMappings table definition below)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("Axis--Image.php");
PageTitle("Save New System Appearance Settings");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# form field / database field mapping
# (must match table in SPT--SysStyle.php)
    $FieldMappings = array(
        "F_BodyCol"         => "PageCenterBackground",
        "F_PCol"            => "PageSideBackground",
        "F_SPTColorHeader"  => "SPTTableHeaderBackground",
        "F_ColorHeader"     => "MDTTableHeaderBackground",
        "F_LightBody"       => "TableBodyBackground",
        "F_ForumTh"         => "ForumDarkHeaderBackground",
        "F_ForumThLight"    => "ForumLightHeaderBackground",
        "F_ForumBack"       => "ForumBodyBackground",
        "F_NavBoxBack"		=> "NavBoxBackground",
        "F_HomeBoxBack"		=> "HomeBoxBackground",
        );

function SaveNewColorValues()
{
    global $HTTP_POST_VARS;
    global $DB;
    global $FieldMappings;

    # for each possible color value
    foreach ($FieldMappings as $FormFieldName => $DBFieldName)
    {
        # save value to database
        $DB->Query("UPDATE UIStyleConfiguration SET "
                   .$DBFieldName." = '".$HTTP_POST_VARS[$FormFieldName]."'");
    }
}

function WriteNewCSSFile()
{
    global $HTTP_POST_VARS;
    global $FieldMappings;
    
    # build replacement patterns
    foreach ($FieldMappings as $FormFieldName => $DBFieldName)
    {
        $Patterns[] = "/X-".strtoupper($DBFieldName)."-X/";
        $Replacements[] = $HTTP_POST_VARS[$FormFieldName];
    }
    
    # build CSS template file and new CSS file names
    $UIPrefix = "SPTUI--Default";
    $TemplateFileName = $UIPrefix."/include/SPT--Stylesheet--Template.css";
    $NewFileName = $UIPrefix."/include/SPT--Stylesheet.css";
    
    # open CSS files
    $TemplateFile = fopen($TemplateFileName, "r");
    $NewFile = fopen($NewFileName, "w");
    
    # while not end of template file
    while (!feof($TemplateFile))
    {
        # read line from template file
        $Line = fgets($TemplateFile, 1024);
        
        # replace any tokens in line
        $Line = preg_replace($Patterns, $Replacements, $Line);
        
        # write line out to new CSS file
        fputs($NewFile, $Line);
    }
    
    # close CSS files
    fclose($TemplateFile);
    fclose($NewFile);
}

function AllNewColorsAreValid()
{
    global $HTTP_POST_VARS;
    global $FieldMappings;
    global $ErrorMessages;
    
    # assume everything is good
    $AllSettingsValid = TRUE;

    # for each possible color value
    foreach ($FieldMappings as $FormFieldName => $DBFieldName)
    {
        # if color value is invalid
        if (!IsValidColorValue(trim($HTTP_POST_VARS[$FormFieldName])))
        {
            # add error flag for value
            $ErrorMessages->AddMessage("Invalid color value entered.  Please correct fields marked in <span style='color:red'>red</span> below.", $FormFieldName);

            # set flag to report to caller
            $AllSettingsValid = FALSE;
        }
    }
    
    # report result back to caller
    return $AllSettingsValid;
}

function IsValidColorValue($Color)
{
    if (preg_match("/^#[0-9A-F]{6}$/i", $Color))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

function UploadedLogoLooksValid()
{
    global $HTTP_POST_FILES;
    global $ErrorMessages;

    if (is_uploaded_file($HTTP_POST_FILES["F_LogoFile"]["tmp_name"]))
    {
        return TRUE;
        if (preg_match("/\\.jpg$/i", $HTTP_POST_FILES["F_LogoFile"]["name"]))
        {
            return TRUE;
        }
        else
        {
            $ErrorMessages->AddMessage("Uploaded logo file must be in JPEG (.JPG) format.", "F_LogoFile");
            return FALSE;
        }
    }
    else
    {
        $ErrorMessages->AddMessage("No logo file uploaded or logo file otherwise appears invalid.", "F_LogoFile");
        return FALSE;
    }
}

function SaveUploadedLogo()
{
    global $DB;
    global $HTTP_POST_VARS;
    global $HTTP_POST_FILES;
    global $HTTP_SERVER_VARS;
    global $ErrorMessages;
    global $SysConfig;

    # assemble and clean up new file name
    $UIPrefix = "SPTUI--Default";
    $UploadedFile = $HTTP_POST_FILES["F_LogoFile"]["tmp_name"];
    $Extensions = array(
        "image/jpeg" => "jpg",
        "image/gif" => "gif",
        "image/png" => "png",
        );
    $NewFileName = "ImageStorage/Logo--".$UIPrefix."."
            .$Extensions[$HTTP_POST_FILES["F_LogoFile"]["type"]];

    # build destination file name
    $DestFile = dirname($HTTP_SERVER_VARS["SCRIPT_FILENAME"])
            ."/".$NavDirCorrection.$NewFileName;

    # move uploaded file to temporary location
    $TempFile = dirname($DestFile)."/TEMP--".basename($DestFile);
    move_uploaded_file($UploadedFile, $TempFile);
    
    # if image type is not supported
    $Img = new Image($TempFile);
    if ($Img->Status() != AI_OKAY)
    {
        $ErrorMessages->AddMessage("Logo graphics file is in an unsupported format.", "F_LogoFile");
    }
    else
    {
        # if resize requested
        if (isset($HTTP_POST_VARS["F_ResizeLogo"])
                && ($HTTP_POST_VARS["F_ResizedLogoSize"] > 0))
        {
            # scale image and save to destination
            $Img->ScaleTo($HTTP_POST_VARS["F_ResizedLogoSize"], NULL, TRUE);
            $Img->SaveAs($DestFile);
        }
        else
        {
            # move uploaded file to destination
            copy($TempFile, $DestFile);
        }

        # save logo file and alt text info
        $DB->Query("UPDATE UIStyleConfiguration SET LogoFileName = '"
                   .$NewFileName."'");
        $DB->Query("UPDATE UIStyleConfiguration SET LogoAltText = '"
                   .addslashes($HTTP_POST_VARS["F_LogoAltText"])."'");

        # save logo image width and height info
        $Img = new Image($DestFile);
        $DB->Query("UPDATE UIStyleConfiguration SET LogoWidth = '"
                   .$Img->XSize()."'");
        $DB->Query("UPDATE UIStyleConfiguration SET LogoHeight = '"
                   .$Img->YSize()."'");
    }

    # remove temporary file
    unlink($TempFile);
}

function ReloadSysConfig()
{
    global $DB;
    global $SysConfig;

    $SysConfig = new SystemConfiguration($DB);
}

function RemoveExistingLogo()
{
    global $DB;
    global $SysConfig;

    # delete old logo image file
    if (file_exists($SysConfig->LogoFileName()))
    {
        unlink($SysConfig->LogoFileName());
    }

    # clear values in database
    $DB->Query("UPDATE UIStyleConfiguration SET LogoFileName = ''");
    $DB->Query("UPDATE UIStyleConfiguration SET LogoAltText = ''");
}


# ----- MAIN -----------------------------------------------------------------

# make sure user has sufficient privileges
CheckAuthorization(PRIV_SYSADMIN);

# create error message list
$ErrorMessages =& new ErrorList();

# select task based on which submit button was pushed
switch ($SubmitResult)
{
    case "Upload New Logo":
        # if uploaded file is available
        if (UploadedLogoLooksValid())
        {
            # save logo and info
            SaveUploadedLogo();
            
            # if there were problems with save
            if ($ErrorMessages->HasErrors())
            {
                # return to the calling page with error messages
                $Session->PassVariable("ErrorMessages");
                PrintAutoRefreshPage("Errors Found with Uploaded Logo", "SPT--SysStyle.php");
            }
            else
            {
                # reload system configuration to reflect change
                ReloadSysConfig();

                # display result to caller
                include("include/SPT--StandardHtmlPageLoad.php");
            }
        }
        else
        {
            # return to the calling page with error messages
            $Session->PassVariable("ErrorMessages");
            PrintAutoRefreshPage("Errors Found with Uploaded Logo", "SPT--SysStyle.php");
        }
        break;

    case "Delete Custom Logo":
        # clear existing custom logo
        RemoveExistingLogo();
        
        # reload system configuration to reflect change
        ReloadSysConfig();

        # display result to caller
        include("include/SPT--StandardHtmlPageLoad.php");
        break;

    case "Change Colors":
        # if all of the new colors look valid
        if (AllNewColorsAreValid())
        {
            # save new settings
            SaveNewColorValues();

            # generate new CSS file
            WriteNewCSSFile();

            # display result to caller
            include("include/SPT--StandardHtmlPageLoad.php");
        }
        else
        {
            # return to the calling page with error messages
            $Session->PassVariable("ErrorMessages");
            
            PrintAutoRefreshPage("Errors Found with New UI Colors Settings", "SPT--SysStyle.php");
        }
        break;

    case "Cancel":
        # return to portal administration menu
        PrintAutoRefreshPage("Cancelling Customize System Appearance", "SPT--SysAdmin.php");
        break;

    default:
        # error out
        # ???
        break;
}


?>
