<?PHP

#
#   FILE:  SPT--SPTOAIServer.php
#
#   METHODS PROVIDED:
#       SPTOAIServer()
#           - constructor
#
#   AUTHOR:  Edward Almasy
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002-2003 Internet Scout Project
#   http://scout.wisc.edu
#

require_once(dirname(__FILE__)."/../Scout--OAIServer.php");
require_once(dirname(__FILE__)."/SPT--SPTDatabase.php");
require_once(dirname(__FILE__)."/SPT--MetadataSchema.php");
require_once(dirname(__FILE__)."/SPT--QualifierFactory.php");
require_once(dirname(__FILE__)."/SPT--Resource.php");


class SPTOAIServer extends OAIServer {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    function SPTOAIServer()
    {
        global $SysConfig;
        global $HTTP_SERVER_VARS;

        # grab our own database handle
        $this->DB =& new SPTDatabase();
        $DB =& $this->DB;
        
        # set up repository description
        $DB->Query("SELECT * FROM SystemConfiguration");
        $Record = $DB->FetchRow();
        $RepDescr["Name"]            = $SysConfig->PortalName();
        $RepDescr["BaseURL"]         = "http://".$HTTP_SERVER_VARS["SERVER_NAME"].$HTTP_SERVER_VARS["PHP_SELF"];
        $RepDescr["DateGranularity"] = "DATE";
        $RepDescr["EarliestDate"]    = $Record["OaiEarliestDate"];
        $RepDescr["AdminEmail"][]    = $SysConfig->AdminEmail();
        $RepDescr["IDDomain"]        = $Record["OaiIdDomain"];
        $RepDescr["IDPrefix"]        = $Record["OaiIdPrefix"];

        # create item factory object for retrieving items from DB
        $this->SPTItemFactory =& new SPTOAIItemFactory();

        # call parent's constructor
        $this->OAIServer($DB, $RepDescr, $this->SPTItemFactory);

        # set up description of nsdl_dc format
        $NsdldcNamespaceList = array(
            "nsdl_dc" => "http://ns.nsdl.org/nsdl_dc_v1.01",
            "dc" => "http://purl.org/dc/elements/1.1/",
            "dct" => "http://purl.org/dc/terms/",
            "ieee" => "http://www.ieee.org/xsd/LOMv1p0",
            );
        $NsdldcElements = array(
            "dc:title",
            "dc:creator",
            "dc:subject",
            "dc:description",
            "dc:publisher",
            "dc:contributor",
            "dc:date",
            "dc:type",
            "dc:format",
            "dc:identifier",
            "dc:source",
            "dc:language",
            "dc:relation",
            "dc:coverage",
            "dc:rights",
            "dct:audience",
            "dct:alternative",
            "dct:tableOfContents",
            "dct:abstract",
            "dct:created",
            "dct:valid",
            "dct:available",
            "dct:issued",
            "dct:modified",
            "dct:extent",
            "dct:medium",
            "dct:isVersionOf",
            "dct:hasVersion",
            "dct:isReplacedBy",
            "dct:replaces",
            "dct:isRequiredBy",
            "dct:requires",
            "dct:isPartOf",
            "dct:hasPart",
            "dct:isReferencedBy",
            "dct:references",
            "dct:isFormatOf",
            "dct:hasFormat",
            "dct:conformsTo",
            "dct:spatial",
            "dct:temporal",
            "dct:mediator",
            "dct:dateAccepted",
            "dct:dateCopyrighted",
            "dct:dateSubmitted",
            "dct:educationLevel",
            "dct:accessRights",
            "dct:bibliographicCitation",
            "ieee:interactivityType",
            "ieee:interactivityLevel",
            "ieee:typicalLearningTime",
            );
        $NsdldcQualifiers = array(
            "dct:LCSH",
            "dct:MESH",
            "dct:DDC",
            "dct:LCC",
            "dct:UDC",
            "dct:DCMIType",
            "dct:IMT",
            "dct:ISO639-2",
            "dct:RFC1766",
            "dct:URI",
            "dct:Point",
            "dct:ISO3166",
            "dct:Box",
            "dct:TGN",
            "dct:Period",
            "dct:W3CDTF",
            "dct:RFC3066",
            );
        $this->AddFormat("nsdl_dc", "nsdl_dc:nsdl_dc", 
                         "http://ns.nsdl.org/nsdl_dc_v1.01"
                         ." http://ns.nsdl.org/schemas/nsdl_dc/nsdl_dc_v1.01.xsd",
                         "1.01.001",
                         $NsdldcNamespaceList, $NsdldcElements, $NsdldcQualifiers);

        # load field mappings from database and set in parent
        $Schema =& new MetadataSchema();
        $DB->Query("SELECT * FROM OAIFieldMappings");
        while ($Record = $DB->FetchRow())
        {
            parent::SetFieldMapping($Record["FormatName"], 
                                    $Record["SPTFieldId"], 
                                    $Record["OAIFieldName"]);
        }

        # load qualifier mappings from database and set in parent
        $DB->Query("SELECT * FROM OAIQualifierMappings");
        while ($Record = $DB->FetchRow())
        {
            $LocalQualifier = new Qualifier($Record["SPTQualifierId"]);
            $LocalQualifierName = $LocalQualifier->Name();
            parent::SetQualifierMapping($Record["FormatName"], 
                                    $LocalQualifierName, 
                                    $Record["OAIQualifierName"]);
        }
    }

    # add SQL conditional for selecting resources
    function AddSQLConditionalForResources($Conditional)
    {
        # pass conditional on to item factory
        $this->SPTItemFactory->AddSQLConditionalForResources($Conditional);
    }
    
    # get/set mapping of local field to OAI field (overloads parent method)
    function GetFieldMapping($FormatName, $LocalFieldName)
    {
        # retrieve ID for local field
        $Schema =& new MetadataSchema();
        $LocalField = $Schema->GetFieldByName($LocalFieldName);
        $LocalFieldId = $LocalField->Id();

        # return stored value
        return parent::GetFieldMapping($FormatName, $LocalFieldId);
    }
    function SetFieldMapping($FormatName, $LocalFieldName, $OAIFieldName)
    {
        # retrieve ID for local field
        $Schema =& new MetadataSchema();
        $LocalField = $Schema->GetFieldByName($LocalFieldName);
        $LocalFieldId = $LocalField->Id();

        # check whether mapping is already in database
        $DB =& $this->DB;
        $MapCount = $DB->Query("SELECT COUNT(*) AS MapCount FROM OAIFieldMappings"
                               ." WHERE FormatName = '".$FormatName."'"
                               ." AND SPTFieldId = '".$LocalFieldId."'",
                               "MapCount");

        # if mapping is already in database
        if ($MapCount > 0)
        {
            # change mapping in database
            $DB->Query("UPDATE OAIFieldMappings"
                       ." SET OAIFieldName = '".addslashes($OAIFieldName)."'"
                       ." WHERE FormatName = '".$FormatName."'"
                       ." AND SPTFieldId = '".$LocalFieldId."'");
        }
        else
        {
            # add new mapping to database
            $DB->Query("INSERT INTO OAIFieldMappings"
                       ." (FormatName, SPTFieldId, OAIFieldName) VALUES"
                       ." ('".$FormatName."', '".$LocalFieldId."', '".addslashes($OAIFieldName)."')");
        }
        
        # call parent method
        parent::SetFieldMapping($FormatName, $LocalFieldId, $OAIFieldName);
    }

    # set mapping of local qualifier to OAI qualifier (overloads parent method)
    function SetQualifierMapping($FormatName, $LocalQualifierName, $OAIQualifierName)
    {
        # retrieve ID for local qualifier
        $QFactory =& new QualifierFactory();
        $LocalQualifier = $QFactory->GetQualifierByName($LocalQualifierName);
        $LocalQualifierId = $LocalQualifier->Id();

        # check whether mapping is already in database
        $DB =& $this->DB;
        $MapCount = $DB->Query("SELECT COUNT(*) AS MapCount FROM OAIQualifierMappings"
                               ." WHERE FormatName = '".$FormatName."'"
                               ." AND SPTQualifierId = '".$LocalQualifierId."'",
                               "MapCount");

        # if mapping is already in database
        if ($MapCount > 0)
        {
            # change mapping in database
            $DB->Query("UPDATE OAIQualifierMappings"
                       ." SET OAIQualifierName = '".addslashes($OAIQualifierName)."'"
                       ." WHERE FormatName = '".$FormatName."'"
                       ." AND SPTQualifierId = '".$LocalQualifierId."'");
        }
        else
        {
            # add new mapping to database
            $DB->Query("INSERT INTO OAIQualifierMappings"
                       ." (FormatName, SPTQualifierId, OAIQualifierName) VALUES"
                       ." ('".$FormatName."', '".$LocalQualifierId."', '".addslashes($OAIQualifierName)."')");
        }
        
        # call parent method
        parent::SetQualifierMapping($FormatName, $LocalQualifierName, $OAIQualifierName);
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $DB;
    var $SPTItemFactory;

}

class SPTOAIItemFactory extends OAIItemFactory {
    
    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function SPTOAIItemFactory()
    {
    }
    
    function GetItem($ItemId)
    {
        # attempt to create item
        $Item = new SPTOAIItem($ItemId);
        
        # if item creation failed
        if ($Item->Status() == -1)
        {
            # return NULL to indicate that no item was found with that ID
            return NULL;
        }
        else
        {
            # return item to caller
            return $Item;
        }
    }
    
    function GetItems($StartingDate = NULL, $EndingDate = NULL)
    {
        # if no dates specified
        $DB =& new SPTDatabase;
        if (($StartingDate === NULL) && ($EndingDate === NULL))
        {
            # select all resources
            $DateConditional = "";
        }
        # else if starting date but no ending date specified
        elseif ($EndingDate === NULL)
        {
            # select all resources created after starting date
            $DateConditional = " AND DateOfRecordCreation >= '".$StartingDate." 00:00:00'";
        }
        # else if ending date but no starting date specified
        elseif ($StartingDate === NULL)
        {
            # select all resources created before ending date
            $DateConditional = " AND DateOfRecordCreation <= '".$EndingDate." 23:59:59'";
        }
        # else both dates must have been specified
        else
        {
            # select all resources created between starting and ending dates
            $DateConditional = " AND DateOfRecordCreation >= '".$StartingDate." 00:00:00'"
                               ." AND DateOfRecordCreation <= '".$EndingDate." 23:59:59'";
        }

        # build query statement
        $ExtraConditionals = "";
        if (isset($this->ResourceConditionals))
        {
            foreach ($this->ResourceConditionals as $Conditional)
            {
                $ExtraConditionals .= " AND ".$Conditional." ";
            }
        }
        $Tables = "Resources";
        if (strstr($ExtraConditionals, "ResourceClassInts")) {  $Tables .= ",ResourceClassInts";  }
        if (strstr($ExtraConditionals, "ResourceNameInts")) {  $Tables .= ",ResourceNameInts";  }
        $Query = "SELECT Resources.ResourceId FROM ".$Tables." WHERE "
                   ." ReleaseFlag = 1"
                   .$DateConditional
                   .$ExtraConditionals
                   ." ORDER BY DateOfRecordCreation ASC";

        # query DB to retrieve resource IDs
        $DB->Query($Query);
        
        # for each selected resource ID
        $ItemIds = array();
        while ($ResourceId = $DB->FetchField("ResourceId"))
        {
            # add resource ID to array to be returned
            $ItemIds[] = $ResourceId;
        }
        
        # return array of resource IDs to caller
        return $ItemIds;
    }

    # add SQL conditional for selecting resources
    function AddSQLConditionalForResources($Conditional)
    {
        $this->ResourceConditionals[] = $Conditional;
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $ResourceConditionals;
}

class SPTOAIItem extends OAIItem {
    
    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function SPTOAIItem($ItemId)
    {
        # save ID for later use
        $this->Id = $ItemId;
        
        # attempt to create resource object
        $this->Resource =& new Resource($ItemId);
        
        # if resource object creation failed
        if ($this->Resource->Status() == -1)
        {
            # set status to -1 to indicate constructor failure
            $this->LastStatus = -1;
        }
        else
        {
            # set status to 1 to indicate constructor success
            $this->LastStatus = 1;
        }
    }
    
    function GetId() {  return $this->Id;  }
    
    function GetDatestamp()
    {
        $DateString = $this->Resource->Get("Date Of Record Creation");
        if ($DateString == "0000-00-00 00:00:00") {  $DateString = date("Y-m-d");  }
        $Date = new SPTDate($DateString);
        return $Date->FormattedISO8601();
    }
    
    function GetValue($ElementName)
    {
        # retrieve value
        $ReturnValue = $this->Resource->GetByFieldId($ElementName);

        # strip out any HTML tags if text value
        if (is_string($ReturnValue))
        {
            $ReturnValue = strip_tags($ReturnValue);
        }

        # return value to caller
        return $ReturnValue;
    }
    
    function GetQualifier($ElementName)
    {
        $ReturnValue = NULL;
        $Qualifier = $this->Resource->GetQualifierByFieldId($ElementName, TRUE);
        if (is_array($Qualifier))
        {
            foreach ($Qualifier as $ItemId => $QualObj)
            {
                if (is_object($QualObj))
                {
                    $ReturnValue[$ItemId] = $QualObj->Name();
                }
            }
        }
        else
        {
            if (is_object($QualObj))
            {
                $ReturnValue = $Qualifier->Name();
            }
        }
        return $ReturnValue;
    }
    
    function Status()
    {
        return $this->LastStatus;
    }
    
    
    # ---- PRIVATE INTERFACE -------------------------------------------------
    
    var $Id;
    var $Resource;
    var $LastStatus;
}


?>
