<?PHP

#
#   Axis--Database.php
#   A Simple SQL Database Abstraction Object
#
#   Copyright 1999-2002 Axis Data
#   This code is free software that can be used or redistributed under the
#   terms of Version 2 of the GNU General Public License, as published by the
#   Free Software Foundation (http://www.fsf.org).
#
#   Author:  Edward Almasy (almasy@axisdata.com)
#
#   Part of the AxisPHP library v1.2.5
#   For more information see http://www.axisdata.com/AxisPHP/
#

require_once("Axis--StandardLibrary.php");


class Database {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    function Database($UserName, $Password, $DatabaseName, $HostName = "localhost")
    {
        # open connection to DB server
        $this->Handle = mysql_connect($HostName, $UserName, $Password)
                or die("could not connect to database");

        # select DB
        mysql_select_db($DatabaseName, $this->Handle)
                or die(mysql_error($this->Handle));

        # save DB access values
        $this->DBHostName = $HostName;
        $this->DBName = $DatabaseName;
        $this->DBUserName = $UserName;
    }

    function DBHostName() {  return $this->DBHostName;  }
    function DBName() {  return $this->DBName;  }
    function DBUserName() {  return $this->DBUserName;  }

    function Query($QueryString, $FieldName = "")
    {
        global $APDBQueryDebugOutputFlag;

        if ($APDBQueryDebugOutputFlag)
        {
            print($QueryString."<br>\n");
        }

        $this->QueryResult = mysql_query($QueryString, $this->Handle)
                or die(mysql_error($this->Handle));

        if (($this->QueryResult != FALSE) && ($FieldName != ""))
        {
            $Row = $this->FetchRow();
            return $Row[$FieldName];
        }
        else
        {
            return $this->QueryResult;
        }
    }

    function NumRowsSelected()
    {
        return mysql_num_rows($this->QueryResult);
    }

    function FetchRow()
    {
        return mysql_fetch_array($this->QueryResult);
    }
    function FetchNextRowArray() {  return $this->FetchRow();  }
    
    function FetchColumn($FieldName, $IndexFieldName = NULL)
    {
        $Array = array();
        while ($Record = $this->FetchRow())
        {
            if ($IndexFieldName != NULL)
            {
                $Array[$Record[$IndexFieldName]] = $Record[$FieldName];
            }
            else
            {
                $Array[] = $Record[$FieldName];
            }
        }
        return $Array;
    }
    
    function FetchField($FieldName)
    {
        $Record = $this->FetchRow();
        return $Record[$FieldName];
    }

    function LastInsertId($TableName)
    {
        return $this->Query(
                "SELECT LAST_INSERT_ID() AS InsertId FROM ".$TableName, 
                "InsertId");
    }
	
	function UpdateValue($TableName, $FieldName, $NewValue, $Condition, &$CachedRecord, $AddSlashes = FALSE)
	{
        # expand condition if supplied
        if ($Condition != NULL) {  $Condition = " WHERE ".$Condition;  }

		# if new value supplied
		if ($NewValue != DB_NOVALUE)
		{
			# if supplied value is integer
			if (is_int($NewValue))
			{
				# update value in database (without quoting value)
				$this->Query("UPDATE $TableName SET $FieldName = $NewValue $Condition");
			}
			else
			{
                # if string escaping requested
                if ($AddSlashes)
                {
                    # update value in database with escaping
                    $this->Query("UPDATE $TableName SET $FieldName = '".addslashes($NewValue)."' $Condition");
                }
                else
                {
                    # update value in database
                    $this->Query("UPDATE $TableName SET $FieldName = '".$NewValue."' $Condition");
                }
			}
			
			# if cached record supplied
            if ($CachedRecord != NULL)
			{
				# update value in cached record
                $CachedRecord[$FieldName] = $NewValue;
			}
			
			# return new value to caller
			return $NewValue;
		}
		else
		{
			# if cached record supplied
            if ($CachedRecord != NULL)
			{
				# return value from cached record to caller
                return $CachedRecord[$FieldName];
			}
			else
			{
				# read value from database and return it to caller
                return $this->Query("SELECT $FieldName FROM $TableName $Condition",
									$FieldName);
			}
		}
	}
    
    function LogComment($String)
    {
        $this->Query("-- ".$String);
    }
    
    function FieldExists($TableName, $FieldName)
    {
        $this->Query("DESC ".$TableName);
        while ($CurrentFieldName = $this->FetchField("Field"))
        {
            if ($CurrentFieldName == $FieldName) {  return TRUE;  }
        }
        return FALSE;
    }

    function QueryDebugOutput($NewSetting)
    {
        global $APDBQueryDebugOutputFlag;
        $APDBQueryDebugOutputFlag = $NewSetting;
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $Handle;
    var $QueryResult;
    var $DBHostName;
    var $DBName;
    var $DBUserName;
}

# define return values  (numerical values correspond to MySQL error codes)
define("DB_OKAY",               0);
define("DB_ERROR",              1);
define("DB_ACCESSDENIED",       2);
define("DB_UNKNOWNDB",          3);
define("DB_UNKNOWNTABLE",       4);
define("DB_SYNTAXERROR",        5);
define("DB_DBALREADYEXISTS",    6);
define("DB_DBDOESNOTEXIST",     7);
define("DB_DISKFULL",           8);

# define value to designate omitted arguments (so DB values can be set to NULL)
define("DB_NOVALUE", "!-_-_-DB_NOVALUE-_-_-!");

# MySQL error code mapping
$APDBErrorCodeMappings = array(
        1045    => DB_ACCESSDENIED,
        1049    => DB_UNKNOWNDB,
        1046    => DB_UNKNOWNTABLE,
        1064    => DB_SYNTAXERROR,
        1007    => DB_DBALREADYEXISTS,  # ?  (not sure)
        1008    => DB_DBDOESNOTEXIST,   # ?  (not sure)
        1021    => DB_DISKFULL,         # ?  (not sure)
        );

# debug output flag
$APDBQueryDebugOutputFlag = FALSE;


function PrintOptionListFromDB($DB, $Table, $Condition, $SortBy, $ResultVar, $ValueQuery, $LabelQuery, $SelectedValue, $Size = 1, $SubmitOnChange = "", $PrintEvenIfEmpty = 0)
{
    # set up condition and sorting parameters
    if ($Condition != "") {  $Condition = "WHERE ".$Condition;  }
    if ($SortBy != "") {  $SortBy = "ORDER BY ".$SortBy;  }

    # grab records to be listed from database
    $QueryString = sprintf("SELECT * FROM %s %s %s", 
            $Table, $Condition, $SortBy);
    $DB->Query($QueryString);

    # if records were found
    if ($DB->NumRowsSelected() > 0)
    {
        # build array of items
        while ($Row = $DB->FetchNextRowArray())
        {
            $Items[$Row[$ValueQuery]] = $Row[$LabelQuery];
        }

        # sort array if not already sorted
        if ($SortBy == "") {  asort($Items);  }
    }

    # print option list
    PrintOptionList($ResultVar, $Items, $SelectedValue, $SubmitOnChange, $Size, $PrintEvenIfEmpty);
}


?>
