<?php

#
#   FILE:  SPT--PurgeSampleDataExecute.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Classification.php");
require_once("include/SPT--Resource.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

PageTitle("Purge Sample Data");
$NavDirCorrection = "../";
$DB =& new SPTDatabase();

# check for cancel button
if($HTTP_POST_VARS["Submit"] == "Cancel")
{
    PrintAutoRefreshPage("System Administration", "../SPT--SysAdmin.php");
    exit;
}

# dump out all necessary fields for all records 
$query = "SELECT ResourceId from Resources where ".
    "INSTR(Description, '[--SAMPLE RECORD--]') > 0"; 

$ResourceCount = 0;
$DB->Query($query);
$ClassIds = array();
$CNIds = array();
while($ResourceId = $DB->FetchField("ResourceId"))
{
    $DB1 =& new SPTDatabase();
    
    $Resource = & new Resource($ResourceId);
    
    # get ClassificationIds associated with this Resource
    $Query = "Select ClassificationId from ResourceClassInts where ".
            "ResourceId = $ResourceId";
    $DB1->Query($Query); 
    while($ClassId = $DB1->FetchField("ClassificationId"))
        $ClassIds[$ClassId] = 1;

    # get ControlledNameIds associated with this Resource
    $Query = "Select ControlledNameId from ResourceNameInts where ".
            "ResourceId = $ResourceId";
    $DB1->Query($Query); 
    while($CNId = $DB1->FetchField("ControlledNameId"))
        $CNIds[$CNId] = 1;

    # delete resource record
    $Resource->Delete();
    $ResourceCount++;
}

# post-process classification ids
$ClassificationCount = 0;
foreach ($ClassIds as $ClassId => $Dummy)
{
    $Class =& new Classification($ClassId);
    if($Class->Status() == CLASSSTAT_OK)
    {
        # delete classification and parents if no other resources assigned
        $Class->Delete(TRUE);
        $ClassificationCount++;
    }
}

# post-process controlledname ids
$ControlledNameCount = 0;
foreach ($CNIds as $CNId => $Dummy)
{
    # see if any resources are still using this controlled name
    $Query = "Select ControlledNameId from ResourceNameInts where ".
            "ControlledNameId = $CNId";
    $DB1->Query($Query); 

    # controlled name is not in use, so delete it
    if($DB1->NumRowsSelected() == 0)
    {
        $DB1->Query("Delete from ControlledNames where ControlledNameId=$CNId");
        $ControlledNameCount++;
    }
}

$Session->PassVariable("ResourceCount", $ResourceCount);
$Session->PassVariable("ClassificationCount", $ClassificationCount);
$Session->PassVariable("ControlledNameCount", $ControlledNameCount);

$NavDirCorrection = "../";
include("include/SPT--StandardHtmlPageLoad.php");

?>
