<?PHP
#
#   FILE:  SPT--RequestAccountComplete.php
#
#   FUNCTIONS PROVIDED:
#       GetUserCreationResultText()
#           - 
#       UserCreationSucceeded()
#           - 
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   OPTIONAL FUNCTIONS:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       F_UserName
#       F_EMail
#       F_EMailAgain
#       F_RealName
#       F_WebSite
#       F_AddressLineOne
#       F_AddressLineTwo
#       F_City
#       F_State
#       F_ZipCode
#       F_Country
#           - user account attributes
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function GetUserCreationResultText()
{
    global $CreationResponseText;

    # return response string to caller
    return $CreationResponseText;
}

function UserCreationSucceeded()
{
    global $CreationResult;
    if ($CreationResult == U_OKAY) {  return TRUE;  } else {  return FALSE;  }
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function CreateNewUser($User, $UserName, $EMail, $EMailAgain, $RealName, 
                       $WebSite, $AddressLineOne, $AddressLineTwo, $City,
                       $State, $ZipCode, $Country)
{
    global $SysConfig;
    global $CreationResult;
    global $CreationResponseText;

    # strings to use in response text
    $ResponseStrings = array(
        U_EMAILSDONTMATCH   => "The two e-mail addresses you entered did not match.  Please use the Back button on your browser to go back and correct them.",
        U_DUPLICATEUSERNAME => "The user name <i>X-USERNAME-X</i> is already in use.  Please use the Back button on your browser to go back and select a different user name.",
        U_ILLEGALUSERNAME   => "The user name <i>X-USERNAME-X</i> is not valid.  User names must be made up of one word containing between 2 and 24 letters and/or numbers.  Please use the Back button on your browser to go back and select a different user name.",
        U_ILLEGALEMAIL      => "The e-mail address <i>X-EMAIL-X</i> does not appear to be valid.  Please use the Back button on your browser to go back and enter a valid e-mail address.",
        U_MAILINGERROR      => "An error was encountered trying to send an e-mail message to confirm your new account.  Please contact the administrator of this site and inform them of the problem.",
        U_OKAY              => "An e-mail message has been sent to <i>X-EMAIL-X</i> with your new password."
    );

    # log user out if currently logged in
    if ($User->IsLoggedIn()) {  $User->Logout();  }

    # make substitutions in password e-mail text
    $MailSubject = $SysConfig->PasswordMailSubject();
    $MailBody = $SysConfig->PasswordMailBody();
    $MailSubject = str_replace(
            "X-PORTALNAME-X", $SysConfig->PortalName(), $MailSubject);
    $MailBody = str_replace(
            "X-PORTALNAME-X", $SysConfig->PortalName(), $MailBody);


    # attempt to create new user
    $CreationResult = $User->CreateNewUserAndMailPassword(
            $UserName, $EMail, $EMailAgain, $MailSubject, $MailBody);

    # set other user parameters if available and if creation succeeded
    if ($CreationResult == U_OKAY)
    {
        if (strlen($RealName) > 0)       {  $User->Set("RealName", $RealName);  }
        if (strlen($WebSite) > 0)        {  $User->Set("WebSite", $WebSite);  }
        if (strlen($AddressLineOne) > 0) {  $User->Set("AddressLineOne", $AddressLineOne);  }
        if (strlen($AddressLineTwo) > 0) {  $User->Set("AddressLineTwo", $AddressLineTwo);  }
        if (strlen($City) > 0)           {  $User->Set("City", $City);  }
        if (strlen($State) > 0)          {  $User->Set("State", $State);  }
        if (strlen($ZipCode) > 0)        {  $User->Set("ZipCode", $ZipCode);  }
        if (strlen($Country) > 0)        {  $User->Set("Country", $Country);  }
        $User->Set("ActiveUI", $SysConfig->DefaultActiveUI());
        $User->GivePriv(PRIV_POSTTOFORUMS);
        $User->GivePriv(PRIV_POSTCOMMENTS);
    }

    # get response string
    $Response = $ResponseStrings[$CreationResult];

    # make any needed substitutions
    $Response = str_replace("X-USERNAME-X", $UserName, $Response);
    $Response = str_replace("X-REALNAME-X", $RealName, $Response);
    $Response = str_replace("X-EMAIL-X", $EMail, $Response);

    # store response string for later retrieval
    $CreationResponseText = $Response;

    # return result of user creation attempt to caller
    return $CreationResult;
}

# ----- MAIN -----------------------------------------------------------------

$F_UserName = $HTTP_POST_VARS["F_UserName"];
$F_Email = $HTTP_POST_VARS["F_Email"];
$F_EmailAgain = $HTTP_POST_VARS["F_EmailAgain"];
$F_RealName = $HTTP_POST_VARS["F_RealName"];
$F_WebSite = $HTTP_POST_VARS["F_WebSite"];
$F_AddressLineOne = $HTTP_POST_VARS["F_AddressLineOne"];
$F_AddressLineTwo = $HTTP_POST_VARS["F_AddressLineTwo"];
$F_City = $HTTP_POST_VARS["F_City"];
$F_State = $HTTP_POST_VARS["F_State"];
$F_ZipCode = $HTTP_POST_VARS["F_ZipCode"];
$F_Country = $HTTP_POST_VARS["F_Country"];


CreateNewUser($User, $F_UserName, $F_EMail, $F_EMailAgain, $F_RealName, 
              $F_WebSite, $F_AddressLineOne, $F_AddressLineTwo, $F_City,
              $F_State, $F_ZipCode, $F_Country);

include(FindUIFile("include/SPT--StandardPageStart.html"));
include(CorrespondingHtmlFile());
include(FindUIFile("include/SPT--StandardPageEnd.html"));


?>
