<?PHP
#
#   FILE:  SPT--Forum.php
#
#   FUNCTIONS PROVIDED:
#       Forum->Forum($ForumId)
#           - constructor
#       Forum->ForumId()
#       Forum->ForumName()
#       Forum->ForumDescription()
#       Forum->TopicCount()
#       Forum->MessageCount()
#       Forum->ModeratorId()
#           - methods to retrieve resource attributes
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once(dirname(__FILE__)."/../Axis--User.php");
require_once(dirname(__FILE__)."/SPT--Common.php");
require_once(dirname(__FILE__)."/SPT--Message.php");

class Forum {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function Forum($ForumId)
    {
        # locate class in database
        $this->DB =& new SPTDatabase();
        $DB =& $this->DB;
        $DB->Query("SELECT * FROM Forums WHERE ForumId = ".$ForumId);

        # load in attributes from database
        $Record = $DB->FetchNextRowArray();
        $this->ForumId =          $ForumId;
        $this->ForumName =        $Record["ForumName"];
        $this->ForumDescription = $Record["ForumDescription"];
        $this->TopicCount =       $Record["TopicCount"];
        $this->MessageCount =     $Record["MessageCount"];
        $this->ModeratorId =      $Record["ModeratorId"];
    }

    # data access methods
    function ForumId()          {  return $this->ForumId;  }
    function ForumName()        {  return $this->ForumName;  }
    function ForumDescription() {  return $this->ForumDescription;  }
    function TopicCount()       {  return $this->TopicCount;  }
    function MessageCount()     {  return $this->MessageCount;  }
    function ModeratorId()      {  return $this->ModeratorId;  }
    

    function LastMessageDate()
    {
        $Message = GetLastMessage($this->ForumId());
        if(isset($Message))
            return $Message->DatePosted()." by ";
        else
            return "None";
    }    

    function LastMessagePoster()
    {
        $Message = GetLastMessage($this->ForumId());
        if(isset($Message))
            return $Message->PosterName();
    }   

    function LastMessagePosterEmail()
    {
        $Message = GetLastMessage($this->ForumId());
        if(isset($Message))
            return $Message->PosterEmail();
    }   

    function ModeratorName()
    {
        $ModeratorName =& new User($this->DB, (int)$this->ModeratorId());
        return $ModeratorName->Get("UserName");
    }

    function ModeratorEmail()
    {
        $ModeratorName =& new User($this->DB, (int)$this->ModeratorId());
        return $ModeratorName->Get("Email");
    }

    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $DB;
    var $ForumId;
    var $ForumName;
    var $ForumDescription;
    var $TopicCount;
    var $MessageCount;
    var $ModeratorId;
    var $LastMessageDate;
    var $LastMessagePoster;
    var $LastMessagePosterEmai;
}

function GetLastMessage($ForumId)
{
    $DB =& new SPTDatabase();
    $Query = "SELECT * FROM Topics WHERE ForumId = ".$ForumId;
    $DB->Query($Query);

    $MostRecent = "0001/01/01 00:00:00";
    while($Entry = $DB->FetchNextRowArray())
    {
        $DB1 =& new SPTDatabase();
        $Query = "SELECT * from Messages where ParentId = ".
                $Entry[TopicId].
                " AND ParentType = 1 ORDER BY DatePosted DESC Limit 1";
        $DB1->Query($Query);
        if($DB1->NumRowsSelected() > 0)
        {
            $Record = $DB1->FetchNextRowArray();
            $Message =& new Message($Record[MessageId]);
            if($Message->DatePosted() > $MostRecent)
            {
                $LastMessage = $Message;
                $MostRecent = $Message->DatePosted();
            }
        }
    }
    return $LastMessage;
}

?>
