<?PHP

#
#   FILE:  SPT--ResourceFactory.php
#
#   METHODS PROVIDED:
#       ResourceFactory()
#           - constructor
#       DuplicateResource($ResourceId)
#           - create duplicate resource and return to caller
#       (SEE ALSO:  SPT--ItemFactory.php)
#
#   AUTHOR:  Edward Almasy  
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

require_once(dirname(__FILE__)."/SPT--ItemFactory.php");
require_once(dirname(__FILE__)."/SPT--Resource.php");


class ResourceFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function ResourceFactory()
    {
        # set up item factory base class
        $this->ItemClassName   = "Resource";
        $this->ItemTableName   = "Resources";
        $this->ItemIdFieldName = "ResourceId";
        $this->ItemFactory();
    }

    # create duplicate resource and return to caller
    function DuplicateResource($ResourceId)
    {
        # create new target resource
        $DstResource =& new Resource();
        
        # load up resource to duplicate
        $SrcResource =& new Resource($ResourceId);
        
        # if resource to duplicate was found
        if ($SrcResource->Status() > 0)
        {
            # for each metadata field
            $Schema =& new MetadataSchema();
            $Fields = $Schema->GetFields();
            foreach ($Fields as $Field)
            {
                # copy values from old resource to new resource
                $DstResource->SetByField($Field, $SrcResource->GetByField($Field, TRUE));
            }
            # must also set DBFields
            $DstResource->DBFields = $SrcResource->DBFields;
        }
        
        # return new resource to caller
        return $DstResource;
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

}


?>
