<?PHP

#
#   Axis--UserFactory.php
#   An Meta-Object for Handling User Information
#
#   Copyright 2003 Axis Data
#   This code is free software that can be used or redistributed under the
#   terms of Version 2 of the GNU General Public License, as published by the
#   Free Software Foundation (http://www.fsf.org).
#
#   Author:  Edward Almasy (almasy@axisdata.com)
#
#   Part of the AxisPHP library v1.2.4
#   For more information see http://www.axisdata.com/AxisPHP/
#

require_once("Axis--User.php");


class UserFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function UserFactory(&$SessionOrDb)
    {
        # if a session was passed in
        if (is_object($SessionOrDb) && method_exists($SessionOrDb, "Session"))
        {
            # swipe database handle from session
            $this->DB =& $SessionOrDb->DB;

            # save session
            $this->Session =& $SessionOrDb;
        }
        # else if database handle was passed in
        elseif (is_object($SessionOrDb) && method_exists($SessionOrDb, "Database"))
        {
            # save database handle
            $this->DB =& $SessionOrDb;

            # create session
            $this->Session =& new Session($this->DB);
        }
        else
        {
            # error out
            $this->Result = U_ERROR;
            exit(1);
        }
    }
    
    # return total number of users in system
    function GetUserCount()
    {
        return $this->DB->Query("SELECT COUNT(*) AS UserCount FROM APUsers", "UserCount");
    }

    # return array of users currently logged in
    function GetLoggedInUsers()
    {
        # start with empty array (to prevent array errors)
        $ReturnValue = array();

        # load array of logged in user
        $UserIds = $this->Session->GetFromAllSessions("APUserId");

        # for each logged in user
        foreach ($UserIds as $UserId)
        {
            # load all data values for user
            $this->DB->Query("SELECT * FROM APUsers WHERE UserId = '".$UserId."'");
            $ReturnValue[$UserId] = $this->DB->FetchRow();
        }

        # return array of user data to caller
        return $ReturnValue;
    }

    # return array of user names who have the specified privileges
    # (array index is user IDs)
    function GetUsersWithPrivileges()
    {
        # start with query string that will return all users
        $QueryString = "SELECT DISTINCT APUsers.UserId, UserName FROM APUsers, APUserPrivileges";

        # for each specified privilege
        $Args = func_get_args();
        foreach ($Args as $Index => $Arg)
        {
            # add condition to query string
            $QueryString .= ($Index == 0) ? " WHERE (" : " OR";
            $QueryString .= " APUserPrivileges.Privilege = ".$Arg;
        }

        # close privilege condition in query string and add user ID condition 
        $QueryString.= count($Args) ? ") AND APUsers.UserId = APUserPrivileges.UserId" : "";

        # perform query
        $this->DB->Query($QueryString);

        # copy query result into user info array
        $Users = $this->DB->FetchColumn("UserName", "UserId");

        # return array of users to caller
        return $Users;
    }

    # return array of users who have values matching search string (in specific field if requested)
    # (search string respects POSIX-compatible regular expressions)
    function GetMatchingUsers($SearchString, $FieldName = NULL, $SortFieldName = "UserName")
    {
        # start with empty array (to prevent array errors)
        $ReturnValue = array();

        # if search string supplied
        if (strlen(trim($SearchString)) > 0)
        {
            # for each user
            $this->DB->Query("SELECT * FROM APUsers");
            while ($Record = $this->DB->FetchRow())
            {
                # if specific field requested
                if ($FieldName !== NULL)
                {
                    # if search string appears in specified field
                    if (ereg($SearchString, $Record[$FieldName]))
                    {
                        # add user to return array
                        $ReturnValue[$Record["UserId"]] = $Record;

                        # add matching search field to return array
                        $ReturnValue[$Record["UserId"]]["APMatchingField"] = $FieldName;
                    }
                }
                else
                {
                    # for each user data field
                    foreach ($Record as $FName => $FValue)
                    {
                        # if search string appears in data field
                        if (ereg($SearchString, $Record[$FName]))
                        {
                            # add user to return array
                            $ReturnValue[$Record["UserId"]] = $Record;

                            # add matching search field to return array
                            $ReturnValue[$Record["UserId"]]["APMatchingField"] = $FName;

                            # move on to next user
                            continue;
                        }
                    }
                }
            }
        }

        # sort list of matching users
        $this->SortFieldName = $SortFieldName;
        usort($ReturnValue, array($this, "CompareUsersForSort"));

        # return array of matching users to caller
        return $ReturnValue;
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $DB;
    var $Session;
    var $SortFieldName;

    # callback function for sorting users
    function CompareUsersForSort($UserA, $UserB)
    {
        return strcasecmp($UserA[$this->SortFieldName], $UserB[$this->SortFieldName]);
    }
};


?>
