<?PHP
#
#   FILE:  SPT--Advanced.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("Axis--UserFactory.php");
require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--SavedSearch.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintSearchTextFormEntries($NumberOfEntries)
{
    global $SavedSearch;

    # if saved search available
    if (isset($SavedSearch))
    {
        # retrieve default values (if any)
        $SearchGroups = $SavedSearch->SearchGroups();
        if ($SearchGroups && isset($SearchGroups["MAIN"]["SearchStrings"]))
        {
            $SavedSearchValues = array_values($SearchGroups["MAIN"]["SearchStrings"]);
        }
    }
    
    # for each requested entry
    for ($Index = 0;  $Index < $NumberOfEntries;  $Index++)
    {
        # use default value from saved search if available
        $DefaultValue = isset($SavedSearchValues[$Index]) ? $SavedSearchValues[$Index] : "";

        # print entry
        PrintSearchTextFormEntry("F_SearchText".$Index, addslashes($DefaultValue), $Index);
    }
}

function PrintSearchTextFieldOptionList($CurrentIndex, $DefaultValue = NULL)
{
    # get list of available metadata fields (if not already retrieved)
    static $FieldList;
    if (!isset($FieldList))
    {
        $Schema =& new MetadataSchema();
        $Fields = $Schema->GetFields(MDFTYPE_TEXT | MDFTYPE_PARAGRAPH 
                | MDFTYPE_CONTROLLEDNAME | MDFTYPE_NUMBER 
                | MDFTYPE_TREE | MDFTYPE_IMAGE | MDFTYPE_DATE | MDFTYPE_TIMESTAMP);
        foreach ($Fields as $FieldId => $Field)
        {
            if ($Field->Enabled() && $Field->Viewable() && $Field->IncludeInAdvancedSearch())
            {
                $FieldList[$FieldId] = $Field->Name();
            }
        }
    }

    # add in keyword search
    $FieldList["Keyword"] = "Keyword";

    # put field in alphabetical order
    asort($FieldList);

    # if valid default value supplied by caller
    if ($DefaultValue && in_array($DefaultValue, $FieldList))
    {  
        # convert default value to value index
        $DefaultValueIndex = array_search($DefaultValue, $FieldList);
    }
    else
    {
        # use keyword as default
        $DefaultValueIndex = "Keyword";
    }

    # print option list
    PrintOptionList("F_SearchCat".$CurrentIndex, $FieldList, $DefaultValueIndex);
}

function PrintSearchLimitFormEntries($FieldTypesOrFieldName = NULL)
{
    global $CurrentField;
    global $User;

    # for each limit of type specified
    $Schema =& new MetadataSchema();
    if (is_string($FieldTypesOrFieldName))
    {
        $Fields = array($Schema->GetFieldByName($FieldTypesOrFieldName));
    }
    else
    {
        $Fields = $Schema->GetFields($FieldTypesOrFieldName);
    }
    foreach ($Fields as $CurrentField)
    {
        # if limit field is marked to be used in Advanced Search
        if ($CurrentField->Enabled() 
                && (($CurrentField->Viewable() && $CurrentField->IncludeInAdvancedSearch())
                    || (($CurrentField->Type() & (MDFTYPE_USER|MDFTYPE_FLAG)) && $User->HasPriv(PRIV_RESOURCEADMIN))))
        {
            # print entry
            PrintSearchLimitFormEntry($CurrentField->Name(), $CurrentField->Type());
        }
    }
}

# called in HTML file to display each option list in Limit Search section
function PrintSearchLimitOptionList($DisplayedListLength)
{
    global $SavedSearch;
    global $CurrentField;
    global $DB;

    # retrieve values for option list
    if ($CurrentField->Type() == MDFTYPE_USER)
    {
        $UserFactory =& new UserFactory($DB);
        $PossibleValues = $UserFactory->GetUsersWithPrivileges(
                PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN, PRIV_RELEASEADMIN);
    }
    else
    {
        if ($CurrentField->Name() == "Cumulative Rating")
        {
            $PossibleValues = array(
                    20 => "*",
                    40 => "**",
                    60 => "***",
                    80 => "****",
                    100 => "*****",
                    );
        }
        else
        {
            $PossibleValues = $CurrentField->GetPossibleValues();
        }
    }

    # assume no default values
    $DefaultValues = NULL;

    # if saved search available
    $FieldId = $CurrentField->Id();
    if (isset($SavedSearch))
    {
        # if default values available
        $SearchGroups = $SavedSearch->SearchGroups();
        if (isset($SearchGroups[$FieldId]["SearchStrings"][$CurrentField->Name()]))
        {
            # if field is a flag or number
            if ($CurrentField->Type() & (MDFTYPE_FLAG|MDFTYPE_NUMBER))
            {
                # use value from SearchGroups directly
                $DefaultValues = preg_replace("/^[=><!]+/", "",
                        $SearchGroups[$FieldId]["SearchStrings"][$CurrentField->Name()]);
            }
            else
            {
                # convert values to indices to match option list values
                $Values = is_array($SearchGroups[$FieldId]["SearchStrings"][$CurrentField->Name()])
                        ? $SearchGroups[$FieldId]["SearchStrings"][$CurrentField->Name()]
                        : array($SearchGroups[$FieldId]["SearchStrings"][$CurrentField->Name()]);
                $DefaultValues = array();
                foreach ($Values as $Value)
                {
                    $Value = preg_replace("/^[=><!]+/", "", $Value);
                    $DefaultValues[] = array_search($Value, $PossibleValues);
                }
            }
        }
    }

    # add null entry if list is only one element long (so user has a way of selecting "no limit")
    if ($DisplayedListLength == 1)
    {
        $PossibleValues = array("-1" => "--") + $PossibleValues;
        if ($DefaultValues == NULL) {  $DefaultValues = "-1";  }
    }

    # print option list
    PrintOptionList("F_SearchLimit".$FieldId."[]", $PossibleValues, 
            $DefaultValues, NULL, $DisplayedListLength, 
            TRUE, $CurrentField->AllowMultiple());
}

# function to return action string for form tag
function GetAdvancedSearchAction()
{
    global $SavedSearch;
    return("SPT--AdvancedSearch.php");
}

# function to return action string for Saved Search string
function GetSavedSearchAction()
{
    return("SPT--SavedSearch.php");
}

# function to print any error messages at top of the page
function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed from PreferencesComplete
    if (isset($ErrorMessages) && is_array($ErrorMessages) &&
        count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul><b>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul></b>\n");
    }
}

# print option list with specified choices for records per page
function PrintRecordsPerPageOptionList()
{
    global $User;

    # for each specified choice
    $Args = func_get_args();
    $Default = -1;
    foreach ($Args as $Arg)
    {
        # add choice to list
        $Choices[$Arg] = $Arg;

        # if default is not yet set and choice is at or above default users last choice
        if (($Default == -1) && ($Arg >= $User->Get("RecordsPerPage")))
        {
            # set default
            $Default = $Arg;
        }
    }

    # print option list
    PrintOptionList("F_RecordsPerPage", $Choices, $Default);
}

# display available saved searches
function DisplayUserSearchList()
{
    global $User;

    # retrieve list of saved searches for current user
    $Searches = GetSavedSearchesForUser($User->Id());

    # if saved searches found
    if (count($Searches))
    {
        # begin search list
        print("<ul class=\"SPTSavedSearches\">\n");

        # for each saved search
        foreach ($Searches as $SearchId => $Search)
        {
            # add entry for search
            $Descrip = addslashes(strip_tags($Search->GetSearchGroupsAsTextDescription()));
            print("<li><a href=\"SPT--Advanced.php?SI=".$Search->GetSearchId()."\" title=\"Search Parameters:\n".$Descrip."\">"
                    .htmlspecialchars($Search->SearchName())."</a></li>\n");
        }

        # end search list
        print("</ul>\n");
    }
    else
    {
        # print messages indicating no searches saved
        print("There are no searches currently saved.");        
    }
}

# get number of searches user has saved
function GetSavedSearchCount()
{
    global $User;
    $Searches = GetSavedSearchesForUser($User->Id());
    return count($Searches);
}

function EditingSavedSearch()
{
    global $SavedSearch;

    return isset($SavedSearch) ? TRUE : FALSE;
}

function PrintSavedSearchName()
{
    global $SavedSearch;

    if (isset($SavedSearch)) {  print($SavedSearch->SearchName());  }
}

function PrintHiddenFormFields()
{
    global $SavedSearch;
    if (isset($SavedSearch))
    {
        print("<input type=\"hidden\" name=\"F_SearchId\" value=\"".$SavedSearch->GetSearchId()."\">\n");
    }
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

if ($User->IsLoggedIn() && isset($HTTP_GET_VARS["SI"]))
{
    $SavedSearch =& new SavedSearch($HTTP_GET_VARS["SI"]);
#    print("<pre>SearchGroups:\n");  print_r($SavedSearch->SearchGroups());  print("</pre>\n");
}

PageTitle("Advanced Search");

include("include/SPT--StandardHtmlPageLoad.php");

?>
