<?PHP

#
#   FILE:  SPT--EditRSSExportComplete.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   FORM FIELDS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

$F_EntriesToPublish = $HTTP_POST_VARS["F_EntriesToPublish"];
$F_NotifyBrowser = $HTTP_POST_VARS['F_NotifyBrowser'];
$F_ChannelTitle = $HTTP_POST_VARS["F_ChannelTitle"];
$F_ChannelDescription = $HTTP_POST_VARS["F_ChannelDescription"];
$F_ImageUrl = $HTTP_POST_VARS["F_ImageUrl"];
$F_ImageTitle = $HTTP_POST_VARS["F_ImageTitle"];
$F_ImageLink = $HTTP_POST_VARS["F_ImageLink"];
$F_ImageHeight = $HTTP_POST_VARS["F_ImageHeight"];
$F_ImageWidth = $HTTP_POST_VARS["F_ImageWidth"];
$F_ImageDescription = $HTTP_POST_VARS["F_ImageDescription"];
$F_Language = $HTTP_POST_VARS["F_Language"];
$F_Copyright = $HTTP_POST_VARS["F_Copyright"];
$F_ManagingEditor = $HTTP_POST_VARS["F_ManagingEditor"];
$F_Webmaster = $HTTP_POST_VARS["F_Webmaster"];
$F_PicsRating = $HTTP_POST_VARS["F_PicsRating"];

$ErrorMessages = & new ErrorList();

# make sure image height/width parameters are legal
if ($F_ImageHeight > 400 || $F_ImageHeight < 0)
{
    $ErrorMessages->AddMessage("Image Height must be <= 400 and > 0");
}
if ($F_ImageWidth > 144 || $F_ImageWidth < 0)
{
    $ErrorMessages->AddMessage("Image Width must be <= 144 and > 0");
}
if ($ErrorMessages->HasErrors())
{
    $Session->PassVariable("ErrorMessages");
    PrintAutoRefreshPage("Errors Found", "SPT--EditRSSExport.php");
    exit;
}

# if save changes was requested
if ($HTTP_POST_VARS["Submit"] != "Cancel")
{
    $DB =& new SPTDatabase();

    $Query = "UPDATE RSSConfiguration SET
        EntriesToPublish = '".addslashes($F_EntriesToPublish)."',
        NotifyBrowser = '".addslashes($F_NotifyBrowser)."',
        ChannelTitle = '".addslashes($F_ChannelTitle)."',
        ChannelDescription = '".addslashes($F_ChannelDescription)."',
        ImageUrl = '".addslashes($F_ImageUrl)."',
        ImageTitle = '".addslashes($F_ImageTitle)."',
        ImageLink = '".addslashes($F_ImageLink)."',
        ImageHeight = '".addslashes($F_ImageHeight)."',
        ImageWidth = '".addslashes($F_ImageWidth)."',
        ImageDescription = '".addslashes($F_ImageDescription)."',
        Language = '".addslashes($F_Language)."',
        Copyright = '".addslashes($F_Copyright)."',
        ManagingEditor = '".addslashes($F_ManagingEditor)."',
        Webmaster = '".addslashes($F_Webmaster)."',
        PicsRating = '".addslashes($F_PicsRating)."'";

#    echo "Query=$Query<br>";
    $DB->Query($Query);
}

# go to parent of edited RSS Export values
PrintAutoRefreshPage("RSS Export Editing Complete", "SPT--SysAdmin.php");

?>
