<?PHP
#
#   FILE:  SPT--ForgottenPasswordComplete.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("Axis--User.php");
require_once("include/SPT--Common.php");
PageTitle("");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function UserNameNotFound()
{
    global $UserNameNotFound;
    return $UserNameNotFound;
}

function BadEmailAddress()
{
    global $BadEmailAddress;
    return $BadEmailAddress;
}

function PrintAccountName()
{
    global $F_UserName;
    print($F_UserName);
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function MailNewPassword($UserName)
{
    global $UserNameNotFound;
    global $BadEmailAddress;
    global $SysConfig;
    global $HTTP_SERVER_VARS;
    global $DB;

    # attempt to pull up user record matching name
    $TUser =& new User($DB, $UserName);

    # if matching user record not found
    if ($TUser == NULL)
    {
        # set flag indicating name not found
        $UserNameNotFound = TRUE;
    }
    else
    {
        # set flag indicating name found
        $UserNameNotFound = FALSE;

        # generate new random password
        $NewPassword = $TUser->GetRandomPassword();

        # if we have a valid-looking e-mail address for user
        $Address = $TUser->Get("EMail");
        if ($TUser->IsValidLookingEMailAddress($Address))
        {
            # assemble body of e-mail message
            $Body = "\n"
                    .$SysConfig->PortalName()."\n"
                    ."Password Reset Request\n"
                    ."\n"
                    ."At (presumably) your request, the password for your account\n"
                    ."has been reset.  The new password is: ".$NewPassword."\n"
                    ."\n"
                    ."\n"
                    ."(For reference, the request came from IP address ".$HTTP_SERVER_VARS["REMOTE_ADDR"].")\n"
                    ."\n";

            # e-mail new password to user
            $Subject = $SysConfig->PortalName()." - Password Reset";
            $Result = mail($Address, $Subject, $Body, 
                           "Reply-To: ".$SysConfig->AdminEmail());

            # if e-mail seems to have succeeded
            if ($Result == TRUE)
            {
                # set new password
                $TUser->Set("UserPassword", crypt($NewPassword));
                
                # set flag indicating e-mail address was good
                $BadEmailAddress = FALSE;
            }
            else
            {
                # set flag indicating e-mail address was bad
                $BadEmailAddress = TRUE;
            }
        }
        else
        {
            # set flag indicating bad e-mail address
            $BadEmailAddress = TRUE;
        }
    }
}


# ----- MAIN -----------------------------------------------------------------

$F_UserName = isset($HTTP_POST_VARS["F_UserName"]) ? $HTTP_POST_VARS["F_UserName"] : NULL;

MailNewPassword($F_UserName);

include(FindUIFile("include/SPT--StandardPageStart.html"));
include(CorrespondingHtmlFile());
include(FindUIFile("include/SPT--StandardPageEnd.html"));

?>
