<?PHP
#
#   FILE:  SPT--FileName.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--MetadataSchema.php");
PageTitle("Loading Saved Search");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# load search for user agents
function LoadUserAgentSearch($SearchId, $EditSearch, $Editing)
{
    global $DB, $User, $Session;

    $UserId = $User->Get("UserId");

    $ErrorMessages = array();

    if ($SearchId)
    {
        $Query = "SELECT * FROM UserSearch where UserId=$UserId and ".
                "SearchId = \"".$SearchId."\"";

        $DB->Query($Query);
        $Entry = $DB->FetchNextRowArray();

        # verify saved search values still available
        $Schema = & new MetadataSchema();
        for ($Index = 1;  $Index < 5;  $Index++)
        {
            $SearchCat = "SearchCat".$Index;
            $Field = $Schema->GetFieldByName($Entry[$SearchCat]);

            if (is_object($Field))
            {
                if (!$Field->Viewable() && !$Editing)
                    $ErrorMessages[] = "ERROR: Saved search value ".
                    "\"".$Entry["$SearchCat"]."\" not viewable to public.";
                        
                if (!$Field->Enabled())
                    $ErrorMessages[] = "ERROR: Saved search value ".
                    "\"".$Entry["$SearchCat"]."\" not enabled.";

                if (count($ErrorMessages))
                    $Session->PassVariable("ErrorMessages", $ErrorMessages);
            }
        }

        $Session->PassVariable("Entry", $Entry);
        if ($EditSearch)
            $Session->PassVariable("SearchId", $SearchId);
        $Session->PassVariable("EditSearch", $EditSearch);
        if ($Editing == 1)
            $Target = "SPT--Advanced.php?Editing=1&SearchId=".$SearchId;
        else
            $Target = "SPT--Advanced.php";
        PrintAutoRefreshPage("Advanced Search", $Target);
        exit;
    }
    else
    {
        $ErrorMessages[] = "ERROR: No Saved Search To Load";
        $Session->PassVariable("ErrorMessages", $ErrorMessages);
        if ($Editing == 1)
            $Target = "SPT--Advanced.php?Editing=1";
        else
            $Target = "SPT--Advanced.php";
        PrintAutoRefreshPage("Error Found", $Target);
        exit;
    }
}


# ----- MAIN -----------------------------------------------------------------

$SearchId = isset($HTTP_GET_VARS["SearchId"]) ? $HTTP_GET_VARS["SearchId"] : $Session->Get("SearchId");
$EditSearch = isset($HTTP_GET_VARS["EditSearch"]) ? $HTTP_GET_VARS["EditSearch"] : $Session->Get("EditSearch");
$Editing = isset($HTTP_GET_VARS["Editing"]) ? $HTTP_GET_VARS["Editing"] : $Session->Get("Editing");

LoadUserAgentSearch($SearchId, $EditSearch, $Editing);

?>
