<?php
#
#   FILE:  SPT--PreviewMessage.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       DisplayAddButtons()
#           - display add, delete, cancel buttons
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Forum.php");
require_once("include/SPT--Topic.php");
require_once("include/SPT--Message.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintHeading()
{
    global $Message;

    if ($Message)
        print "Preview Message";
    else
        print "Preview Topic and Message";
}

function PrintSubmitButton()
{
    global $Message;

    if ($Message)
        print "Post New Message";
    else
        print "Add New Topic and Message";

}

function PrintEditButton()
{
    global $Message;

    if ($Message)
        print "Edit Message";
    else
        print "Edit Topic and Message";

}

function PrintForumId()
{
    global $F_ForumId;

    print $F_ForumId;
}

function PrintParentId()
{
    global $Session;

    $ParentId = $Session->Get("ParentId");

    print $ParentId;
}

function PrintForumName()
{
    global $ForumName;

    print stripslashes($ForumName);
}

function PrintTopic()
{
    global $F_TopicName;

    print stripslashes($F_TopicName);
}

function PrintBody()
{
    global $F_Body;

    print stripslashes($F_Body);
}

function PrintSubject()
{
    global $F_Subject;

    print stripslashes($F_Subject);
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

$F_ForumId = $Session->Get("forumid");

$Forum =& new Forum($F_ForumId);
$ForumName = $Forum->ForumName();
$ModeratorId = $Forum->ModeratorId();

$Message = $Session->Get("Message");
$ParentId = $Session->Get("ParentId");
$F_Subject = $Session->Get("F_Subject");
$F_Body = $Session->Get("F_Body");
$F_TopicName = $Session->Get("F_TopicName");

#if (!empty($HTTP_GET_VARS["messageid"]))
#{
#    $MessageId = $HTTP_GET_VARS["messageid"];
#    $Message =& new Message($MessageId);
#    $Subject = $Message->Subject();
#    $Body = $Message->Body();
#    $PosterId = $Message->PosterId();
#}

$Session->PassVariable("Message", $Message);
$Session->PassVariable("forumid", $F_ForumId);
$Session->PassVariable("F_Subject", $F_Subject);
$Session->PassVariable("F_Body", $F_Body);
$Session->PassVariable("F_TopicName", $F_TopicName);
$Session->PassVariable("ParentId", $ParentId);

PageTitle("Preview Message");
include("include/SPT--StandardHtmlPageLoad.php");

?>
