<?PHP
#
#   FILE:  SPT--TopicMessages.php
#
#   FUNCTIONS PROVIDED:
#       - PrintForumName()
#       - PrintForumDescription()
#       - PrintTopicName()
#       - PrintVar()
#       - CheckForModeratorOrSysAdmin()
#       - CheckForUserLoggedIn()
#       - DisplayMessages()
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Forum.php");
require_once("include/SPT--Topic.php");
require_once("include/SPT--Message.php");
PageTitle("Topic Messages");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed 
    if (count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

function PrintForumName()
{
    global $ForumName;

    print $ForumName;
}

function PrintForumDescription()
{
    global $ForumDescription;

    print $ForumDescription;
}


function PrintTopicName()
{
    global $TopicName;

    print $TopicName;
}

function PrintVar($VarName)
{
    print $VarName;
}

function CheckForModeratorOrSysAdmin()
{
    global $User, $ModeratorId;

    if (($User->Get("UserId") == $ModeratorId && 
        $User->HasPriv(PRIV_FORUMADMIN))
        || $User->HasPriv(PRIV_SYSADMIN))
        return true;
    else
        return false;
}

function CheckForUserLoggedIn()
{
    global $User;

    if ($User->IsLoggedIn() == TRUE)
        return true;
    else
        return false;
}

function DisplayMessages()
{
    global $TopicId;
    global $ForumId;
    global $PosterId;
    global $MessageCount;

    $Topic = & new Topic($TopicId);
    $Messages = $Topic->GetMessageList();
    $MessageCount = count($Messages);

    foreach ($Messages as $MessageId => $Message)
    {
        $Subject = $Message->Subject();
        $Body = $Message->Body();
        $DatePosted = $Message->DatePosted();
        $PosterId = $Message->PosterId();
        $PosterName = $Message->PosterName();
        $PosterEmail = $Message->PosterEmail();
        $EditOkay = CheckForEdit();
        $EditLink = "SPT--PostMessage.php?forumid=".
            "$ForumId&topicid=$TopicId&messageid=$MessageId"; 
        $DeleteLink = "SPT--PostMessage.php?forumid=".
            "$ForumId&topicid=$TopicId&messageid=$MessageId";

        # see if this user has permission to remove posting privileges    
        if(CheckForRemovePostPrivilege())
            $RemovePostPrivLink = "SPT--UpdateTopic.php?forumid=".
                "$ForumId&topicid=$TopicId&messageid=$MessageId".
                "&Submit=".urlencode("Remove Post Privilege");
        else
            $RemovePostPrivLink = NULL;
        PrintForumMessage($Subject, $Body, $DatePosted, $PosterName,
            $PosterEmail, $EditOkay, $EditLink, $DeleteLink, 
            $RemovePostPrivLink, FALSE);
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# update the viewcount every time page is loaded
function UpdateViewCount()
{
    global $TopicId;

    $Topic = & new Topic($TopicId);
    $ViewCount = $Topic->ViewCount();
    $Topic->ViewCount($ViewCount + 1);
}

# see if user has permission to edit the message
function CheckForEdit()
{
    global $User, $ModeratorId, $PosterId;

    if ($User->Get("UserId") == $ModeratorId || 
        ($User->Get("UserId") == $PosterId &&
        $User->HasPriv(PRIV_POSTTOFORUMS)) ||
        $User->HasPriv(PRIV_FORUMADMIN))
        return true;
    else
        return false;
}

# check if user can remove post privilege
function CheckForRemovePostPrivilege()
{
    global $User, $ModeratorId;

    if ($User->HasPriv(PRIV_FORUMADMIN) &&
        $User->HasPriv(PRIV_USERADMIN))
        return true;
    else
        return false;
}

# ----- MAIN -----------------------------------------------------------------


if (isset($HTTP_GET_VARS["topicid"]))
    $TopicId = $HTTP_GET_VARS["topicid"];
else
    $TopicId = $Session->Get("topicid");
$Topic =& new Topic($TopicId);
$TopicName = $Topic->TopicName();

if (isset($HTTP_GET_VARS["forumid"]))
    $ForumId = $HTTP_GET_VARS["forumid"];
else
    $ForumId = $Session->Get("forumid");
$Forum =& new Forum($ForumId);
$ForumName = $Forum->ForumName();
$ForumDescription = $Forum->ForumDescription();
$ModeratorId = $Forum->ModeratorId();

$ErrorMessages = $Session->Get("ErrorMessages");

UpdateViewCount();

include("include/SPT--StandardHtmlPageLoad.php");

?>
