<?PHP

#
#   FILE:  SPT--UpdateForum.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Forum.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# remove selected forum 
function RemoveForum()
{
    global $HTTP_POST_VARS, $Session;

    $F_ForumId = $HTTP_POST_VARS["F_ForumId"];
    if (is_null($F_ForumId))
        $F_ForumId = $Session->Get("F_ForumId");

    if (!empty($F_ForumId))
    {
        $Forum = & new Forum($F_ForumId);
        $Forum->Delete();
    }
}

# add new forum 
function AddForum()
{
    global $F_ForumName, $F_ForumDescription, $F_ForumModeratorId;
    global $Session, $HTTP_POST_VARS;

    $F_ForumName = $HTTP_POST_VARS["F_ForumName"];
    if (is_null($F_ForumName))
        $F_ForumName = $Session->Get("F_ForumName");

    $F_ForumDescription = $HTTP_POST_VARS["F_ForumDescription"];
    if (is_null($F_ForumDescription))
        $F_ForumDescription = $Session->Get("F_ForumDescription");
        
    # make sure not empty strings
    if (strlen($F_ForumName) && strlen($F_ForumDescription))
    {
        $Forum = & new Forum();
        $Forum->ForumName($F_ForumName);
        $Forum->ForumDescription($F_ForumDescription);
        $Forum->TopicCount("0");
        $Forum->MessageCount("0");
        $Forum->ModeratorId($F_ForumModeratorId);
    }
    else
    {
        $ErrorMessages[] = 
            "Error: Forum name and description are required fields.";
        $Session->PassVariable("ErrorMessages", $ErrorMessages);
        $Session->PassVariable("F_ForumName", $F_ForumName);
        $Session->PassVariable("F_ForumDescription", $F_ForumDescription);
        PrintAutoRefreshPage("ErrorMessage", "SPT--AddForum.php");
        exit;
    }
}

# edit selected forum
function EditForum()
{
    global $Session, $F_ForumId;

    $Forum = & new Forum($F_ForumId);

    $Session->PassVariable("F_ForumDescription", $Forum->ForumDescription());
    $Session->PassVariable("F_ForumName", $Forum->ForumName());
    $Session->PassVariable("Edit", 1);
}

# update selected forum
function UpdateForum()
{
    global $HTTP_POST_VARS, $Session, $F_ForumId, $F_ForumModeratorId;

    $F_ForumName = $HTTP_POST_VARS["F_ForumName"];
    if (is_null($F_ForumName))
        $F_ForumName = $Session->Get("F_ForumName");

    $F_ForumDescription = $HTTP_POST_VARS["F_ForumDescription"];
    if (is_null($F_ForumDescription))
        $F_ForumDescription = $Session->Get("F_ForumDescription");

    $Forum = & new Forum($F_ForumId);    
    $Forum->ForumName($F_ForumName);
    $Forum->ForumDescription($F_ForumDescription);
    $Forum->ModeratorId($F_ForumModeratorId);
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_SYSADMIN);

if (isset($HTTP_POST_VARS["Submit"]))
    $Submit = $HTTP_POST_VARS["Submit"];
else
    $Submit = NULL;

if (isset($HTTP_POST_VARS["F_ForumId"]))
    $F_ForumId = $HTTP_POST_VARS["F_ForumId"];
else    
    $F_ForumId = $Session->Get("F_ForumId");

if (isset($HTTP_POST_VARS["F_ForumModeratorId"]))
    $F_ForumModeratorId = $HTTP_POST_VARS["F_ForumModeratorId"];
else
    $F_ForumModeratorId = NULL;

# check for Cancel button from previous screen
if ($Submit=="Cancel")
{
    PrintAutoRefreshPage("SPT Home", "SPT--Home.php");
}
else if (substr($Submit, 0, 6) == "Remove")
{
    RemoveForum();
}
else if (substr($Submit, 0, 3) == "Add")
{
    AddForum();
}
else if (substr($Submit, 0, 4) == "Edit")
{
    EditForum();
}
else if (substr($Submit, 0, 6) == "Update")
{
    UpdateForum();
}

# return to add forum page
$Session->PassVariable("F_ForumId", $F_ForumId);
$Session->PassVariable("F_ForumModeratorId", $F_ForumModeratorId);
PrintAutoRefreshPage("Add Forum", "SPT--AddForum.php");

?>
