<?PHP

#
#   FILE:  SPT--UpdateTopic.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#
require_once("include/SPT--Common.php");
require_once("include/SPT--Forum.php");
require_once("include/SPT--Topic.php");
require_once("include/SPT--Message.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# preview new comment
function PreviewComment()
{
    global $Session;
    global $ParentId;
    global $F_Subject;
    global $F_Body;
    global $Message;
    global $ResourceId;

    # remove unwanted html tags
    $F_Body = strip_tags($F_Body, '<a><b><i><u><br><small>');

    # return to home page
    $Session->PassVariable("Message", $Message);
    $Session->PassVariable("F_Subject", $F_Subject);
    $Session->PassVariable("F_Body", $F_Body);
    $Session->PassVariable("ParentId", $ParentId);
    $Session->PassVariable("ResourceId", $ResourceId);
    
    # make sure a comment has been entered
    if (strlen($F_Body))
        PrintAutoRefreshPage("Preview Comment", "SPT--PreviewComment.php");
    # tell user to enter a comment     
    else
    {
        $ErrorMessages[] = "Error: You must enter a comment.";
        $Session->PassVariable("ErrorMessages",$ErrorMessages);
        PrintAutoRefreshPage("Error Message", "SPT--AddResourceComment.php");
    }
    exit;
}

# preview post 
function PreviewNewTopic()
{
    global $Session;
    global $ForumId;
    global $ParentId;
    global $F_TopicName;
    global $F_Subject;
    global $F_Body;
    global $Message;

    # return to home page
    $Session->PassVariable("Message", $Message);
    $Session->PassVariable("F_Subject", $F_Subject);
    $Session->PassVariable("F_Body", $F_Body);
    $Session->PassVariable("F_TopicName", $F_TopicName);
    $Session->PassVariable("forumid", $ForumId);
    $Session->PassVariable("ParentId", $ParentId);
    PrintAutoRefreshPage("Preview Post", "SPT--PreviewMessage.php");
    exit;
}

# delete topic and messages
function DeleteTopic()
{
    global $ParentId;

    if (!empty($ParentId))
    {
        $Topic = & new Topic($ParentId);

        $DeletedCount = 0;
        $Messages = $Topic->GetMessageList();
        foreach ($Messages as $MessageId => $Message)
        {
            $Message->Delete();
            $DeletedCount++;
        }

        # update counts for forum
        $Forum = & new Forum($Topic->ForumId());
        $MessageCount = $Forum->MessageCount();
        $Forum->MessageCount($MessageCount - $DeletedCount);
        $TopicCount = $Forum->TopicCount();
        $Forum->TopicCount($TopicCount - 1);
        $Topic->Delete();
    }
}

# delete comment
function DeleteComment()
{
    global $Session, $ParentId, $MessageId;

    $Message = & new Message($MessageId);
    $Message->Delete();
    $Session->PassVariable("ResourceId", $ParentId);
    PrintAutoRefreshPage("Full Record", "SPT--FullRecord.php");
    exit;
}

# delete message 
function DeleteMessage()
{
    global $ForumId, $ParentId, $MessageId, $ParentType;

    if (!empty($MessageId))
    {
        $Message = & new Message($MessageId);

        # update count for topic and forum
        $Topic = & new Topic($Message->ParentId());
        $MessageCount = $Topic->MessageCount();
        $Topic->MessageCount($MessageCount - 1);

        $Forum = & new Forum($Message->ParentId());
        $MessageCount = $Forum->MessageCount();
        $Forum->MessageCount($MessageCount - 1);

        # delete the message
        $Message->Delete();
    }
}

# update comment
# comments are treated much like messages, except ParentId = 2
function UpdateComment()
{
    global $User, $Session, $F_Subject, $F_Body, $ParentId, $ParentType;

    # overload UpdateMessage to deal with comments as well
    UpdateMessage();
    $Session->PassVariable("ResourceId", $ParentId);
    PrintAutoRefreshPage("Full Record", "SPT--FullRecord.php");
    exit;
}

# update message 
function UpdateMessage()
{
    global $User, $MessageId, $F_Subject, $F_Body, $ForumId, $ParentId;
    global $F_TopicName, $Session, $ParentType;

    # remove unwanted html tags
    $F_Subject = strip_tags($F_Subject, '<a><b><i><u><small>');
    $F_Body = strip_tags($F_Body, '<a><b><i><u><br><small>');

    # update the post
    if (strlen($F_Subject) && strlen($F_Body))
    {
        # add info that message was edited
        $F_Body .= "\n\n<br><br><small>This message edited by ".
                    $User->Get("UserName").
                    " on ".date("F j, Y \a\\t g:i a")."</small>";

        $Message = & new Message($MessageId);
        $Message->Body($F_Body);
        $Message->Subject($F_Subject);
        $Message->DatePosted(date("YmdHis"));
    }
    else
    {
        # normal formum message
        if ($ParentType == 1)
        {
            $Session->PassVariable("topicid", $ParentId);
            $ErrorMessages[] = "Error: One or more missing values. ".
                "Make sure all values are filled in.";
            $Target = "SPT--PostMessage.php";
        }
        # resource comment
        else
        {
            $Session->PassVariable("ResourceId", $ParentId);
            $ErrorMessages[] = "Error: You must enter a comment";
            $Target = "SPT--AddResourceComment.php";
        }
       
        $Session->PassVariable("ErrorMessages",$ErrorMessages);
        $Session->PassVariable("F_Subject", $F_Subject);
        $Session->PassVariable("F_Body", $F_Body);
        $Session->PassVariable("F_TopicName", $F_TopicName);
        $Session->PassVariable("forumid", $ForumId);
        $Session->PassVariable("messageid", $MessageId);
        PrintAutoRefreshPage("Error Message", $Target);
        exit;
    }
}

# add list value
function AddNewTopic()
{
    global $User, $Session, $F_TopicName, $ForumId, $F_Subject, $F_Body;
    global $ParentId, $ParentType;

    $UserId = $User->Get("UserId");

    # remove unwanted html tags
    $F_TopicName = strip_tags($F_TopicName, '<a><b><i><u><small>');

    # check for required fields
    if (strlen($F_TopicName) && strlen($F_Subject) && strlen($F_Body))
    {
        $Topic = & new Topic();
        $ParentId = $Topic->TopicId();
        $Topic->TopicName($F_TopicName);
        $Topic->DateCreated(date("YmdHis"));
        $Topic->ForumId($ForumId);
        $Topic->ViewCount("0");
        $Topic->MessageCount("0");
        $Topic->CreatorId($UserId);

        $Forum = & new Forum($ForumId);
        $TopicCount = $Forum->TopicCount();
        $Forum->TopicCount($TopicCount + 1);
        
        # Now Post the message
        $ParentType = 1;
        PostMessage();
    }
    # missing values
    else
    {
        $ErrorMessages[] = "Error: One or more missing values. ".
            "Make sure all values are filled in.";
        $Session->PassVariable("ErrorMessages",$ErrorMessages);
        $Session->PassVariable("F_Subject", $F_Subject);
        $Session->PassVariable("F_Body", $F_Body);
        $Session->PassVariable("F_TopicName", $F_TopicName);
        $Session->PassVariable("forumid", $ForumId);
        $Session->PassVariable("ParentId", $ParentId);
        PrintAutoRefreshPage("Error Message", "SPT--AddTopic.php");
        exit;
    }
}

# comments are treated much like messages, except ParentId = 2
function AddComment()
{
    global $User, $Session, $F_Subject, $F_Body, $ParentId, $ParentType;

    $Session->PassVariable("ResourceId", $ParentId);

    # overload PostMessage to deal with comments as well
    PostMessage();
    PrintAutoRefreshPage("Full Record", "SPT--FullRecord.php");
    exit;
}

function EditMessage()
{
    global $Session, $F_Subject, $F_Body, $ParentId, $ForumId;

    $Session->PassVariable("forumid", $ForumId);
    $Session->PassVariable("topicid", $ParentId);
    $Session->PassVariable("F_Subject", $F_Subject);
    $Session->PassVariable("F_Body", $F_Body);

    PrintAutoRefreshPage("Edit Message", "SPT--PostMessage.php");
    exit;
}

function EditTopic()
{
    global $Session, $F_TopicName, $ParentId, $ForumId;

    $Session->PassVariable("forumid", $ForumId);
    $Session->PassVariable("topicid", $ParentId);
    $Session->PassVariable("F_TopicName", $F_TopicName);

    PrintAutoRefreshPage("Edit Topic", "SPT--EditTopic.php");
    exit;
}

function UpdateTopic()
{
    global $F_TopicName, $ParentId;

    # remove unwanted html tags
    $F_TopicName = strip_tags($F_TopicName, '<a><b><i><u><small>');

    $Topic = & new Topic($ParentId);
    $Topic->TopicName($F_TopicName);
}

function EditTopicAndMessage()
{
    global $Session, $F_Subject, $F_Body, $ParentId, $ForumId;
    global $F_TopicName;

    $Session->PassVariable("forumid", $ForumId);
    $Session->PassVariable("topicid", $ParentId);
    $Session->PassVariable("F_TopicName", $F_TopicName);
    $Session->PassVariable("F_Subject", $F_Subject);
    $Session->PassVariable("F_Body", $F_Body);

    PrintAutoRefreshPage("Edit Message", "SPT--AddTopic.php");
    exit;
}

function PostMessage()
{
    global $User, $Session, $F_Subject, $F_Body, $ParentId, $ForumId;
    global $ParentType, $F_TopicName;

    # PosterId is the user
    $PosterId = $User->Get("UserId");

    # remove unwanted html tags
    $F_Subject = strip_tags($F_Subject, '<a><b><i><u><small>');
    $F_Body = strip_tags($F_Body, '<a><b><i><u><br><small>');

    # now insert the message
    if (strlen($F_Subject) && strlen($F_Body))
    {
        $Message = & new Message();
        $Message->ParentId($ParentId);
        $Message->ParentType($ParentType);
        $Message->DatePosted(date("YmdHis"));
        $Message->PosterId($PosterId);
        $Message->Subject($F_Subject);
        $Message->Body($F_Body);

        # update counts for topic and forum
        if ($ParentType == 1)
        {
            $Forum = & new Forum($ForumId);
            $MessageCount = $Forum->MessageCount();
            $Forum->MessageCount($MessageCount + 1);

            $Topic = & new Topic($ParentId);
            $MessageCount = $Topic->MessageCount();
            $Topic->MessageCount($MessageCount + 1);
        }
    }
    # report errors
    else
    {
        # normal formum message
        if ($ParentType == 1)
        {
            $ErrorMessages[] = "Error: One or more missing values. ".
                "Make sure all values are filled in.";
            $Target = "SPT--PostMessage.php";
        }
        # resource comment
        else
        {
            $ErrorMessages[] = "Error: You must enter a comment";
            $Target = "SPT--AddResourceComment.php";
        }
       
        $Session->PassVariable("ErrorMessages",$ErrorMessages);
        $Session->PassVariable("F_Subject", $F_Subject);
        $Session->PassVariable("F_Body", $F_Body);
        $Session->PassVariable("F_TopicName", $F_TopicName);
        $Session->PassVariable("forumid", $ForumId);
        $Session->PassVariable("topicid", $ParentId);
        PrintAutoRefreshPage("Error Message", $Target);
        exit;
    }
}

# remove posting privilege for message poster
function RemovePostPrivilege()
{
    global $User;
    global $Session;
    global $messageid;
    global $ErrorMessages;

    $DB =& new SPTDatabase();

    # recheck user privileges to perform this operation
    if ($User->HasPriv(PRIV_FORUMADMIN) &&
        $User->HasPriv(PRIV_USERADMIN))
    {
        # get this message
        $Message = & new Message($messageid);

        # get poster
        $Poster =& new User($DB, (int)$Message->PosterId());

        # revoke their posting privileges
        $Poster->RevokePriv(PRIV_POSTTOFORUMS);
        $ErrorMessages[] = "Posting privilege removed for User \"".
                $Poster->Get("UserName")."\".";
        $Session->PassVariable("ErrorMessages", $ErrorMessages);
    }
}

# ----- MAIN -----------------------------------------------------------------

if (isset($HTTP_POST_VARS["ResourceId"]))
    $ResourceId = $HTTP_POST_VARS["ResourceId"];
else
    $ResourceId = $Session->Get("ResourceId");

if (isset($HTTP_GET_VARS["forumid"]))
    $ForumId = $HTTP_GET_VARS["forumid"];
else if (isset($HTTP_POST_VARS["forumid"]))
    $ForumId = $HTTP_POST_VARS["forumid"];
else
    $ForumId = $Session->Get("forumid");

if (isset($HTTP_GET_VARS["topicid"]))
    $ParentId = $HTTP_GET_VARS["topicid"];
else if (isset($HTTP_POST_VARS["topicid"]))
    $ParentId = $HTTP_POST_VARS["topicid"];
else
    $ParentId = $Session->Get("topicid");

# check for ParentId from Resource
if (is_null($ParentId))
    $ParentId = $Session->Get("ParentId");

if (isset($HTTP_POST_VARS["F_Subject"]))
    $F_Subject = $HTTP_POST_VARS["F_Subject"];
else if (isset($HTTP_GET_VARS["F_Subject"]))
    $F_Subject = $HTTP_GET_VARS["F_Subject"];
else
    $F_Subject = $Session->Get("F_Subject");

if (isset($HTTP_POST_VARS["F_Body"]))
    $F_Body = $HTTP_POST_VARS["F_Body"];
else if (isset($HTTP_GET_VARS["F_Body"]))
    $F_Body = $HTTP_GET_VARS["F_Body"];
else
    $F_Body = $Session->Get("F_Body");

if (isset($HTTP_POST_VARS["F_TopicName"]))
    $F_TopicName = $HTTP_POST_VARS["F_TopicName"];
else
    $F_TopicName = $Session->Get("F_TopicName");

if (isset($HTTP_GET_VARS["messageid"]))
    $messageid = $HTTP_GET_VARS["messageid"];
else
    $messageid = $Session->Get("messageid");

if (isset($HTTP_GET_VARS["message"]))
    $message = $HTTP_GET_VARS["message"];
else    
    $message = $Session->Get("message");

if (isset($HTTP_POST_VARS["Submit"]))
    $Submit = $HTTP_POST_VARS["Submit"];
else
    $Submit = $HTTP_GET_VARS["Submit"];

if (isset($HTTP_POST_VARS["OkayToDelete"]))
    $OkayToDelete = $HTTP_POST_VARS["OkayToDelete"];
else
    $OkayToDelete = FALSE;

# echo "forumid=$forumid, topicid=$topicid, messageid=$messageid<br>";
# echo "Submit=$Submit, F_Body=$F_Body, ParentId=$ParentId<br>";

# don't allow any operation if user is not logged in
if ($User->IsLoggedIn() == FALSE)
{
    $ErrorMessages[] = "Error: User must be logged in to perform ".
        "perform this function.";

    if (isset($ResourceId))
    {
        $Session->PassVariable("ResourceId", $ResourceId);
        PrintAutoRefreshPage("Full Record", "SPT--FullRecord.php");
    }
    else
    {
        $Session->PassVariable("ErrorMessages",$ErrorMessages);
        $Session->PassVariable("F_Subject", $F_Subject);
        $Session->PassVariable("F_Body", $F_Body);
        $Session->PassVariable("F_TopicName", $F_TopicName);
        $Session->PassVariable("forumid", $ForumId);
        $Session->PassVariable("topicid", $ParentId);
        $Session->PassVariable("messageid", $MessageId);
        PrintAutoRefreshPage("Error Message", "SPT--PostMessage.php");
    }
    exit;
}
    
# this variable determines if we are coming from a message screen or not
if (isset($message))
    $Message = 1;

# comments are type 2, messages are type 1
if ($Submit == "Add Comment")
{
    $ParentType = 2;
    AddComment();
}
# add new topic & message
else if (substr($Submit, 0, 3) == "Add")
{
    AddNewTopic();
}
# update just the topic 
else if ($Submit == "Update Topic")
{
    UpdateTopic();
}
# edit existing topic
else if ($Submit == "Edit Topic")
{
    EditTopic();
}
# post new comment
else if ($Submit == "Post New Comment")
{
    $ParentType = 2;
    AddComment();
}
# just post a new message
else if (substr($Submit, 0, 4) == "Post")
{
    $ParentType = 1;
    PostMessage();
    $Message = 1;
}
# edit a new message from preview
else if ($Submit == "Edit Message")
{
    $ParentType = 1;
    EditMessage();
    $Message = 1;
}
# edit a new topic and message from preview
else if ($Submit == "Edit Topic and Message")
{
    $ParentType = 1;
    EditTopicAndMessage();
    $Message = 1;
}
# update a comment
else if ($Submit == "Update Comment")
{
    UpdateComment();
    $Message = 1;
}
# update an edited message
else if (substr($Submit, 0, 6) == "Update")
{
    UpdateMessage();
    $Message = 1;
}
# preview new topic and message, or preview comment
else if ($Submit == "Preview")
{
    if (isset($ResourceId))
        PreviewComment();
    else
        PreviewNewTopic();
}
# remove Topic from forum
else if ($Submit == "Delete Topic")
{
    if ($OkayToDelete) 
    {
        DeleteTopic();
    }
    # give user a second chance
    else
    {
        $Session->PassVariable("forumid", $ForumId);
        $Session->PassVariable("topicid", $ParentId);
        PrintAutoRefreshPage("Add Topic", "SPT--ConfirmDeleteTopic.php");
        exit;
    }
}
# preview new topic and message
else if ($Submit == "Delete Comment")
{
    $ParentType = 2;
    DeleteComment();
}
# delete a message
else if ($Submit == "Delete Message")
{
    $ParentType = 1;
    DeleteMessage();
}
# delete a message
else if ($Submit == "Remove Post Privilege")
{
    $ParentType = 1;
    $Message = 1;
    RemovePostPrivilege();
}
# else Cancel, fall through
if (isset($ResourceId))
{
    $Session->PassVariable("ResourceId", $ResourceId);
    PrintAutoRefreshPage("Full Record", "SPT--FullRecord.php");
    exit;
}

# return to home page
$Session->PassVariable("forumid", $ForumId);
if (isset($ParentId))
    $Session->PassVariable("topicid", $ParentId);

if (isset($Message))
    PrintAutoRefreshPage("Add Message", "SPT--TopicMessages.php");
else
    PrintAutoRefreshPage("Add Topic", "SPT--ForumTopics.php");

?>
