<?php

#
#   FILE:  SPT--UserLogin.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");

# try to log user in
$LoginResult = NULL;
if (isset($HTTP_POST_VARS["F_UserName"]) && isset($HTTP_POST_VARS["F_Password"]))
{
    $LoginResult = $User->Login($HTTP_POST_VARS["F_UserName"],
                    $HTTP_POST_VARS["F_Password"]);
}

# if login was successful
if ($LoginResult == U_OKAY)
{
    # is user account disabled?
    if ($User->HasPriv(PRIV_USERDISABLED))
    {
        # log user out
        $User->Logout();
        PrintAutoRefreshPage("Login Error", "SPT--LoginError.php");
        exit;
    }
    else
    {
        # list of pages we do not want to return to
        $DoNotReturnToPages = array(
                "SPT--LoginError.php",
                "SPT--ForgottenPasswordComplete.php",
                "SPT--RequestAccountComplete.php",
                );
        # if originating page looks like a valid destination
        $OrigPage = basename($HTTP_SERVER_VARS["HTTP_REFERER"]);
        $OrigPagePieces = explode("?", $OrigPage);
        $OrigPageFile = array_shift($OrigPagePieces);
        if (!in_array($OrigPageFile, $DoNotReturnToPages) && file_exists($OrigPageFile))
        {
            # head to originating page
            PrintAutoRefreshPage("User Logged In", $OrigPage);
        }
        else
        {
            # head to home page
            PrintAutoRefreshPage("User Logged In", "SPT--Home.php");
        }
    }
}
else
{
    # go to login error page
    PrintAutoRefreshPage("Login Error", "SPT--LoginError.php");
}

?>
