<?PHP
#
#   FILE:  SPT--Local--EXAMPLE.php
#
#   DESCRIPTION:
#     This file contains examples of functions that can be put into the file
#     include/SPT--Local.php and be called by the SPT code at appropriate points.
#
#   USAGE:
#     1) copy this file to include/SPT--Local.php
#     2) remove "EXAMPLE_" from the name of the function(s) you want to use
#     3) replace the code between the "EXAMPLE CODE" lines with your code
#
#   Part of CWIS and the Scout Portal Toolkit
#   Copyright 2006 Internet Scout
#   http://scout.wisc.edu
#

#
#    FUNCTION:  Local_SavedSearchKeywordReplacement()
# CALLED WHEN:  generating saved search e-mail messages
#
# NOTES:
#   - should return replacement text
#   - $ResourceId and $ResultNumber are supplied when the function is called
#       within a specific result
#   - $User is an SPTUser object representing the user receiving the e-mail
#
function EXAMPLE_Local_SavedSearchKeywordReplacement(
        $Keyword, $User, $Search, $ResourceId = NULL, $ResultNumber = NULL)
{
# -----vvvvv EXAMPLE CODE vvvvv-----
    # if keyword is the one we are looking for
    if ($Keyword == "X-OURKEYWORD-X")
    {
        # use our replacement text
        $Replacement = "Our Replacement";
    }
    else
    {
        # otherwise send back NULL to indicate that we don't have a replacement
        $Replacement = NULL;
    }

    # return replacement text to caller
    return $Replacement;
# -----^^^^^ EXAMPLE CODE ^^^^^-----
}

#
#    FUNCTION:  Local_GetOAIRetrievalSearchParameters()
# CALLED WHEN:  responding to OAI queries
#
# NOTES:
#   - should return array of one or more search conditions that resources have
#       to meet to be retrievable via OAI (conditions are ANDed together)
#   - array indices are field names and array values are values to search for
#   - prepend "=" to match an exact value
#   - prepend ">" or "<" to match relative values (only meaningful for numbers
#       and dates)
#   - syntax is the same as used for the OSMASE fielded search method (as in
#       part described above)
#
function EXAMPLE_Local_GetOAIRetrievalSearchParameters()
{
# -----vvvvv EXAMPLE CODE vvvvv-----
    return array(
            "Release Flag" => 1,
            "Language" => "=English",
            );
# -----^^^^^ EXAMPLE CODE ^^^^^-----
}


?>
