<?PHP

#
#   FILE:  SPT--ResourceFactory.php
#
#   METHODS PROVIDED:
#       ResourceFactory()
#           - constructor
#       DuplicateResource($ResourceId)
#           - create duplicate resource and return to caller
#       (SEE ALSO:  SPT--ItemFactory.php)
#
#   AUTHOR:  Edward Almasy  
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

require_once(dirname(__FILE__)."/SPT--ItemFactory.php");
require_once(dirname(__FILE__)."/SPT--Resource.php");


class ResourceFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function ResourceFactory()
    {
        # set up item factory base class
        $this->ItemFactory("Resource", "Resources", "ResourceId");
    }

    # create duplicate resource and return to caller
    function DuplicateResource($ResourceId)
    {
        # create new target resource
        $DstResource =& new Resource();
        
        # load up resource to duplicate
        $SrcResource =& new Resource($ResourceId);
        
        # if resource to duplicate was found
        if ($SrcResource->Status() > 0)
        {
            # for each metadata field
            $Schema =& new MetadataSchema();
            $Fields = $Schema->GetFields();
            foreach ($Fields as $Field)
            {
                # copy values from old resource to new resource (except for cumulative rating)
                if ($Field->Name() != "Cumulative Rating")
                {
                    $DstResource->SetByField($Field, $SrcResource->GetByField($Field, TRUE));
                }
            }
        }
        
        # return new resource to caller
        return $DstResource;
    }

    # clear or change specific qualifier for all resources
    function ClearQualifier($ObjectOrId, $NewObjectOrId = NULL)
    {
        # get ID of qualifier to clear
        if (is_object($ObjectOrId))
        {
            $QualifierId = $ObjectOrId->Id();
        }
        else
        {
            $QualifierId = $ObjectOrId;
        }

        # if new qualifier passed in
        if ($NewObjectOrId !== NULL)
        {
            # get ID of qualifier to change to
            if (is_object($NewObjectOrId))
            {
                $NewQualifierIdVal = "'".$NewObjectOrId->Id()."'";
            }
            else
            {
                $NewQualifierIdVal = "'".$NewObjectOrId."'";
            }
        }
        else
        {
            # qualifier should be cleared
            $NewQualifierIdVal = "NULL";
        }

        # for each metadata field
        $DB =& new SPTDatabase();
        $Schema =& new MetadataSchema();
        $Fields = $Schema->GetFields();
        foreach ($Fields as $Field)
        {
            # if field uses qualifiers and uses item-level qualifiers
            $QualColName = $Field->DBFieldName()."Qualifier";
            if ($Field->UsesQualifiers() 
                && $Field->HasItemLevelQualifiers() 
                && $DB->FieldExists("Resources", $QualColName))
            {
                # set all occurrences to new qualifier value
                $DB->Query("UPDATE Resources"
                           ." SET ".$QualColName." = ".$NewQualifierIdVal.""
                           ." WHERE ".$QualColName." = '".$QualifierId."'");
            }
        }

        # clear or change qualifier association with controlled names
        # (NOTE: this should probably be done in a controlled name factory object)
        $DB->Query("UPDATE ControlledNames"
                   ." SET QualifierId = ".$NewQualifierIdVal
                   ." WHERE QualifierId = '".$QualifierId."'");

        # clear or change qualifier association with classifications
        # (NOTE: this should probably be done in a classification factory object)
        $DB->Query("UPDATE Classifications"
                   ." SET QualifierId = ".$NewQualifierIdVal
                   ." WHERE QualifierId = '".$QualifierId."'");
    }
    
    # return count of rated resources
    function GetRatedResourceCount()
    {
        $DB =& new SPTDatabase();
        $RatedResourceCount = $DB->Query("SELECT COUNT(DISTINCT ResourceId) AS ResourceCount "
                ."FROM ResourceRatings", "ResourceCount");
        return $RatedResourceCount;
    }

    # return recently released resources
    function GetRecentlyReleasedResources($Count = 10, $Offset = 0, $MaxDaysToGoBack = 90)
    {
        # assume that no resources will be found
        $Resources = array();

	# calculate cutoff date for resources
	$CutoffDate = date("Y-m-d H:i:s", strtotime($MaxDaysToGoBack." days ago"));

	# query for resource IDs
	$DB =& new SPTDatabase();
	$DB->Query("SELECT ResourceId FROM Resources WHERE"
	        ." DateOfRecordRelease > '".$CutoffDate."'"
		." AND ReleaseFlag = 1"
		." AND ResourceId >= 0"
		." ORDER BY DateOfRecordRelease DESC, DateOfRecordCreation DESC"
		." LIMIT ".$Offset.", ".$Count);
	$ResourceIds = $DB->FetchColumn("ResourceId");

        # for each resource ID found
	foreach ($ResourceIds as $ResourceId)
	{
	    # load resource and add to list of found resources
	    $Resources[$ResourceId] =& new Resource($ResourceId);
	}

	# return found resources to caller
	return $Resources;
    }

    # get date/time of last resource modification (returned as Unix timestamp)
    function GetTimestampOfLastResourceModification($OnlyReleasedResources = TRUE)
    {
        $DB =& new SPTDatabase();
        $LastChangeDate = $DB->Query("SELECT MAX(DateLastModified) AS LastChangeDate"
                ." FROM Resources".($OnlyReleasedResources ? " WHERE ReleaseFlag = 1" : ""),
                "LastChangeDate");
        return ($LastChangeDate ? strtotime($LastChangeDate) : NULL);
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

}


?>
