<?PHP
#
#   FILE:  AddTopic.php
#
#   FUNCTIONS PROVIDED:
#       PrintForumId()
#       PrintForumName()
#       PrintErrorMessages()
#       DisplayTopics()
#
#   FUNCTIONS EXPECTED:
#       DisplayAddButtons()
#           - display add, delete, cancel buttons
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintForumId()
{
    global $ForumId;

    print $ForumId;
}

function PrintForumName()
{
    global $ForumName;

    print StripXSSThreats(stripslashes($ForumName));
}

function PrintTopic()
{
    global $F_TopicName;

    print StripXSSThreats(stripslashes($F_TopicName));
}

function PrintSubject()
{
    global $F_Subject;

    print StripXSSThreats(GetHtmlEscapedString($F_Subject));
}

function PrintBody()
{
    global $F_Body;

    print StripXSSThreats(GetHtmlEscapedString($F_Body));
}

# print out any error messages
function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed
    if (count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $F_Body;
global $F_Subject;
global $F_TopicName;
global $ForumId;
global $ForumName;

if (isset($_GET["ForumId"]))
    $ForumId = intval($_GET["ForumId"]);
else
    $ForumId = $Session->Get("ForumId");
$Forum = new Forum($ForumId);
$ForumName = $Forum->ForumName();

if (isset($_POST["F_TopicName"]))
    $F_TopicName = $_POST["F_TopicName"];
else
    $F_TopicName = $Session->Get("F_TopicName");
if (isset($_POST["F_Subject"]))
    $F_Subject = $_POST["F_Subject"];
else
    $F_Subject = $Session->Get("F_Subject");
if (isset($_POST["F_Body"]))
    $F_Body = $_POST["F_Body"];
else
    $F_Body = $Session->Get("F_Body");

PageTitle("Add Topic");
if (!CheckAuthorization(PRIV_POSTTOFORUMS)) {  return;  }

?>
