<?php

#
#   FILE:  SPT--EditUser.php
#
#   FUNCTIONS PROVIDED:
#       PrintCurrentRealName()
#       PrintCurrentEMail()
#       PrintCurrentWebSite()
#       PrintCurrentAddressLineOne()
#       PrintCurrentAddressLineTwo()
#       PrintCurrentCity()
#       PrintCurrentState()
#       PrintCurrentZipCode()
#       PrintCurrentCountry()
#           - print various attributes of user being edited (for form fields)
#       UserFound()
#           - returns TRUE if requested user was found for editing
#       PrintRequestedUserName()
#           - prints name of requested user
#       PrintDisableUser()
#           - print value for USERDISABLED
#       PrintUserPrivOptionList()
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       F_UserName
#           - account name of user to be edited
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

PageTitle("Edit User Information");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintCurrentRealName()       {  global $UserToEdit;  print($UserToEdit->Get("RealName"));  }
function PrintCurrentEMail()          {  global $UserToEdit;  print($UserToEdit->Get("EMail"));  }
function PrintCurrentWebSite()        {  global $UserToEdit;  print($UserToEdit->Get("WebSite"));  }
function PrintCurrentAddressLineOne() {  global $UserToEdit;  print($UserToEdit->Get("AddressLineOne"));  }
function PrintCurrentAddressLineTwo() {  global $UserToEdit;  print($UserToEdit->Get("AddressLineTwo"));  }
function PrintCurrentCity()           {  global $UserToEdit;  print($UserToEdit->Get("City"));  }
function PrintCurrentState()          {  global $UserToEdit;  print($UserToEdit->Get("State"));  }
function PrintCurrentZipCode()        {  global $UserToEdit;  print($UserToEdit->Get("ZipCode"));  }
function PrintCurrentCountry()        {  global $UserToEdit;  print($UserToEdit->Get("Country"));  }

function UserFound() {  global $UserWasFound;  return $UserWasFound;  }
function PrintRequestedUserName() {  global $F_UserName;  print($F_UserName);  }

# print if user is disabled or not
function PrintUserDisabled()
{
    global $UserToEdit;
    $UserPrivList = $UserToEdit->GetPrivList();
    if (in_array(PRIV_USERDISABLED, $UserPrivList))
        print " checked";
}

# this function is used both locally and exported
function IsEditingOwnAccount()
{
    global $User;

    # user is logged in and is not SYSADMIN or USERADMIN
    if ((!$User->HasPriv(PRIV_SYSADMIN) &&
        !$User->HasPriv(PRIV_USERADMIN)) &&
        $User->IsLoggedIn() == TRUE)
        return TRUE;
    else
        return FALSE;
}

# this just looks if user is editing his own account
function AmEditingMyself()
{
    global $User, $UserToEdit;

    # user is logged in and is not SYSADMIN or USERADMIN
    if ($UserToEdit->Get("UserId") == $User->Get("UserId"))
        return TRUE;
    else
        return FALSE;
}

function PrintUserPrivOptionList()
{

    global $PrivDescriptions, $UserToEdit, $User;

    $UserPrivList = $UserToEdit->GetPrivList();

    # print option list begin
    print("<select name=\"F_Privileges[]\" id=\"F_Privileges[]\"".
        " style=\"width: auto;\" multiple>\n");

    # for each element in list
    $PrivFact = new PrivilegeFactory();
    $Privileges = $PrivFact->GetPrivileges(TRUE, FALSE);
    foreach ( $Privileges as $Id => $Label )
    {
        # disable sys admin or user account admin privileges as a safeguard
        if ($UserToEdit->Get("UserId") == $User->Get("UserId") &&
            $User->HasPriv(PRIV_SYSADMIN) &&
            ($Id == PRIV_SYSADMIN || $Id == PRIV_USERADMIN))
        {
            print "    <option value=\"".$Id."\" disabled=\"disabled\"";
            print ">".htmlspecialchars($Label)."</option>\n";
        }

        # don't display "User Account Disabled" on priv list
        else if ($Id != PRIV_USERDISABLED)
        {
            print("    <option value=\"".$Id."\"");
            if (in_array($Id, $UserPrivList)) {  print(" selected");  }
            print(">".htmlspecialchars($Label)."</option>\n");
        }
    }

    # print option list end
    print("</select>\n");

}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function LoadUser($UserName)
{
    global $UserWasFound;
    global $DB;
    global $User;
    global $Session;
    global $UserToEdit;
    global $IdOfUserBeingEdited;
    global $PrivDescriptions;

    # if user name looks okay
    if ($User->IsValidUserName($UserName))
    {
        # search for user in database
        $UserToEdit = new User($DB, $UserName);

        # if user was found
        if ($UserToEdit->Status() == U_OKAY)
        {
            # set flag indicating user was found with specified name
            $UserWasFound = TRUE;

            # remove SYSADMIN and USERADMIN option for non-sysadmin users
            if (!$User->HasPriv(PRIV_SYSADMIN))
            {
                unset($PrivDescriptions[PRIV_SYSADMIN]);
                unset($PrivDescriptions[PRIV_USERADMIN]);
            }

            # remove SYSADMIN option for sysadmin users if editing yourself
            if ($UserToEdit->Get("UserId") == $User->Get("UserId") &&
                $User->HasPriv(PRIV_SYSADMIN))
            {
                unset($PrivDescriptions[PRIV_SYSADMIN]);
            }

            # save user ID for use when saving edited values
            $IdOfUserBeingEdited = $UserToEdit->Get("UserId");
            $Session->RegisterVariable("IdOfUserBeingEdited");
        }
        else
        {
            # set flag indicating no user found with specified name
            $UserWasFound = FALSE;
        }
    }
    else
    {
        # set flag indicating no user found with specified name
        $UserWasFound = FALSE;
    }
}


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $F_UserName;
global $IdOfUserBeingEdited;
global $PrivDescriptions;
global $UserToEdit;
global $UserWasFound;

# allow user to edit his/her own info
if (IsEditingOwnAccount())
{
    LoadUser($User->Get("UserName"));
}

# check if current user is authorized
else
{
    if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }
    if (isset($_POST["F_UserName"]))
        LoadUser($_POST["F_UserName"]);
    # got here from search for user list
    else
        LoadUser($_GET["F_UserName"]);
}


?>
