<?PHP

class OpenId extends Plugin
{
    function Register()
    {
        $this->Name = "OpenID Login";
        $this->Version = "1.0.0";
        $this->Description = "Provides users with the option to log in with an "
                ."<a href=\"http://openid.net\" target=\"_blank\">OpenID</a>, "
                ."allowing them to use the same login across multiple websites.";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
            "CWISCore" => "1.9.0"
            );
    }

    function Install()
    {
        $DB = new Database();

        $DB->Query("CREATE TABLE OpenId_UserMap ("
                   ."DisplayId TEXT, "
                   ."UserName TEXT)"
            );

    }

    function DeclareEvents()
    {
        return array();
    }

    function HookEvents()
    {
        return array(
            "EVENT_APPEND_HTML_TO_FORM" => "ModifyLoginForm",
            "EVENT_PHP_FILE_LOAD" => "InspectFormAndMaybeRedirect"
            );
    }

    function InspectFormAndMaybeRedirect($PageName)
    {
        $Dest = $PageName;
        if ($PageName == "UserLogin" && !isset($_POST["SkipOpenId"]) &&
            isset($_POST["F_OidDisplayed"]) && strlen($_POST["F_OpenId"])>0 )
        {
            $Dest = "P_OpenId_TryAuth";
        }

        global $Session;
        $OidLoginError = $Session->Get("OidLoginError");
        if ($OidLoginError !== NULL)
        {
            $Session->PassVariable("OidLoginError", $OidLoginError);
        }

        return array("PageName" => $Dest);
    }

    function ModifyLoginForm($PageName, $FormName, $Labels, $InputElements, $Notes)
    {
        if ($FormName=="LoginForm")
        {
            if ($PageName === "")
            {
                global $AF;
                $Labels []= "<br>Log in with OpenID:";
                $InputElements []= '<input type="hidden" name="F_OidDisplayed" value="1">'
                    .'<input type="text" name="F_OpenId" size="15" '
                    .'style="background-image: url(./plugins/OpenId/OpenID_logo_small.png); '
                    .'background-repeat: no-repeat; padding-left: 16px; ">'
                    .'<input type="image" src="'.$AF->GUIFile("go.gif").'" '
                    .'style="margin: 0px 0px -5px 6px;"><br>';
                $Notes []= "To login with an OpenId, enter your OpenID URL below. "
                    ."Login with a Google Profile by entering 'google.com/profiles/YOUR_GOOGLE_PROFILE'. "
                    ."Login with yahoo by entering 'yahoo.com'";
            }
            else if ($PageName === "LoginError")
            {
                global $Session;

                $OidLoginError = $Session->Get("OidLoginError");

                if ($OidLoginError !== NULL)
                {
                    $Labels []= $OidLoginError;
                    $InputElements []= "&nbsp;";
                    $Notes []= "";

                    $Session->UnregisterVariable("OidLoginError");
                }
            }
        }

        return array(
            "PageName" => $PageName,
            "FormName" => $FormName,
            "Labels"   => $Labels,
            "InputElements" => $InputElements,
            "Notes"         => $Notes);
    }
}

?>
