<?php

// This is the landing page on which OpenId responses will fall It
// needs to be its own page because (at least some) OID servers bork
// up the query string when they construct their response.

// Here, we'll pull in just enough of CWIS to dump the OID response
// out into the $Session, then redirect back into the OID plugin
// proper to get back inside CWIS.

ob_start();
require_once("../../config.php");
require_once('../../lib/AxisPHP/Axis--Database.php');
require_once('../../lib/AxisPHP/Axis--Session.php');

Database::SetGlobalServerInfo($SPT_DBUserName, $SPT_DBPassword, $SPT_DBHost);
Database::SetGlobalDatabaseName($SPT_DBName);

$DB = new Database();

# Pull in the php-openid components that I need.
ini_set('include_path', ini_get('include_path') . PATH_SEPARATOR .
        dirname(__FILE__)."/php-openid");
require_once "Auth/OpenID/Consumer.php";
require_once "Auth/OpenID/SReg.php";
require_once "OpenId_AxisDatabase.php" ;
require_once "OpenId_AxisDatabaseStore.php";

$store =  new Auth_OpenID_AxisDatabaseStore( new Auth_OpenId_AxisDatabase() );
$store->createTables();

$consumer =& new Auth_OpenID_Consumer($store);

// Complete the authentication process using the server's
// response.
$TrustRoot = sprintf("http://%s:%s%s",
                     $_SERVER['SERVER_NAME'],
                     $_SERVER['SERVER_PORT'],
                     dirname($_SERVER['PHP_SELF']));
$RedirectTo = $TrustRoot . "/FinishAuthLanding.php";
$response = $consumer->complete($RedirectTo);

$OidData["Timestamp"] = time();

$OidData["Status"] = $response->status;
if ($response->status == Auth_OpenID_SUCCESS )
{
    $OidData["DisplayId"] = $response->getDisplayIdentifier();
    $OidData["CanonicalId"] = $response->endpoint->canonicalID;

    $sreg_resp = Auth_OpenID_SRegResponse::fromSuccessResponse($response);
    $sreg = $sreg_resp->contents();
    $OidData["ExtendedInfo"] = $sreg;
}

$DataSerial = base64_encode(gzdeflate(serialize($OidData)));
$CkSum = md5($DataSerial.$SPT_DBUserName.$SPT_DBPassword.$SPT_DBHost);

header("Location: "
       .sprintf("http://%s:%s%s/index.php?P=P_OpenId_FinishAuth",
                $_SERVER['SERVER_NAME'],
                $_SERVER['SERVER_PORT'],
                dirname(dirname(dirname($_SERVER['PHP_SELF']))))
       ."&D=".urlencode($DataSerial)."&C=".$CkSum);

ob_end_flush();

?>