<?PHP

#
#   FILE:  SPT--ConfirmRemoveUser.php
#
#   FUNCTIONS PROVIDED:
#       PrintUserName()
#       - print out topic name 
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.cs.wisc.edu
#

PageTitle("Confirm Remove User");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to return true if users have been selected for removal
function RemoveUsersExist()
{
    global $UserRemoveArray;

    return count($UserRemoveArray);
}

function PrintUserList()
{
    global $Session, $UserRemoveArray;
    
    $DB = new SPTDatabase();

    foreach ($UserRemoveArray as $UserId)
    {
        $RemoveUser = new User($DB, intval($UserId));
        print $RemoveUser->Get("UserName")."<br>";
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $UserRemoveArray;

$UserRemoveArray = $Session->Get("UserRemoveArray");

$Session->PassVariable("OkayToRemove", 1);
$Session->PassVariable("UserRemoveArray", $UserRemoveArray);

if (!CheckAuthorization( PRIV_USERADMIN, PRIV_SYSADMIN )) {  return;  }

?>
