<?PHP
#
#   FILE:  AuthenticationCallback.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function GetLocalUri($PageName)
{
    # remove two layers of directories if in the global plugins directory,
    # otherwise remove three
    $BaseUrl = is_int(strpos(__FILE__, "local/plugins"))
        ? preg_replace('/[^\/]+\/[^\/]+\/[^\/]+\/$/', "", OurBaseUrl())
        : preg_replace('/[^\/]+\/[^\/]+\/$/', "", OurBaseUrl());

    return $BaseUrl . "index.php?P=" . $PageName;
}

# ----- MAIN -----------------------------------------------------------------

# need to get to the root directory
$Root = "../../";
$Root .= (is_int(strpos(__FILE__, "local/plugins"))) ? "../" : "";
chdir($Root);

# set up operating environment
require_once("include/StartUp.php");

$YouTube = $G_PluginManager->GetPlugin("YouTube");

# make sure the user is authorized
if (!$User->HasPriv(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN))
{
    $YouTube->Redirect(GetLocalUri("Home"));
    return;
}

# don't continue authentication if already authenticated
if ($YouTube->IsAuthenticated())
{
    $YouTube->Redirect(GetLocalUri("Plugins"));
    return;
}

$Token = GetArrayValue($_GET, "token");

# exchange the token for a session token if a token was given
if (!empty($Token))
{
    $YouTube->ExchangeToken($Token);

    # go to the plugins page
    $YouTube->Redirect(GetLocalUri("Plugins"));
    return;
}
