<?PHP
#
#   FILE: EditForm.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

?>

<div id="youtube-editform">
  <h4>Upload Video</h4>
  <label for="P_YouTube_Title">Title</label>
  <input type="text" id="P_YouTube_Title" name="P_YouTube_Title" />

  <label for="P_YouTube_Description">Description</label>
  <textarea id="P_YouTube_Description" name="P_YouTube_Description"></textarea>
</div>

<noscript>
  <p class="cw-form-error">
    The YouTube plugin requires Javascript to function fully.
  </p>
</noscript>

<div class="youtube-actions">
  <ul class="cw-list cw-list-unmarked cw-list-horizontal youtube-actions-list">
    <li class="youtube-actions-logo"><img src="<?PHP print $UrlPrefix; ?>plugins/YouTube/images/youtube_16.png" alt="YouTube" /></li>
    <li class="youtube-actions-title" title="[TITLE]"><a href="http://www.youtube.com/watch?v=[YOUTUBE_ID]" target="_blank">[SHORT_TITLE]</a></li>
    <li class="youtube-actions-status"></li>
    <li class="youtube-actions-edit"><a class="cw-button cw-button-elegant cw-button-constrained" href="http://www.youtube.com/my_videos_edit?video_id=[YOUTUBE_ID]" title="Manage the YouTube video" target="_blank">Manage</a></li>
    <li class="youtube-actions-reupload"><a class="cw-button cw-button-elegant cw-button-constrained" href="index.php?P=P_YouTube_ReuploadYouTubeVideo&amp;FileId=[FILE_ID]&amp;ReturnTo=<?PHP print $ReturnTo; ?>" title="Upload the video to YouTube">Upload</a></li>
    <li class="youtube-actions-remove"><a class="cw-button cw-button-elegant cw-button-constrained" href="index.php?P=P_YouTube_DeleteYouTubeVideo&amp;VideoId=[VIDEO_ID]&amp;ReturnTo=<?PHP print $ReturnTo; ?>" title="Remove the video from YouTube">Remove</a></li>
  </ul>
</div>

<script type="text/javascript">
  $(document).ready(function(){
    var state = $.parseJSON('<?PHP print json_encode($State); ?>'),
        userName = "<?PHP print $UserName; ?>",
        $editForm = $("#youtube-editform"),
        $cell = $editForm.parent(),
        $row = $cell.parent(),
        $fileList = $("ul li", $cell),
        $upload = $("td > input", $row);

    // add a new class name to the row to apply styling
    $row.addClass("youtube-edit");

    // move the upload inputs to the end of the form
    $upload.insertAfter($editForm);

    // make sure the row is always vertically aligned by the top
    $row.addClass("cw-content-tallrow");

    $fileList.each(function(){
      var fileId, $youtubeActions, video, html;
      var $element = $("input[value='Delete']", this);

      if ($element.length) {
        fileId = $element.attr("name").match(/DeleteFile_([0-9]+)/)[1];
        video = state[fileId];

        html = $(".youtube-actions").html();
        html = htmlReplace(html, "[TITLE]", video.Title);
        html = htmlReplace(html, "[DESCRIPTION]", video.Description);
        html = htmlReplace(html, "[SHORT_TITLE]", video.ShortTitle);
        html = htmlReplace(html, "[FILE_ID]", video.FileId);
        html = htmlReplace(html, "[VIDEO_ID]", video.VideoId);
        html = htmlReplace(html, "[YOUTUBE_ID]", video.YouTubeId);

        $youtubeActions = $(html);
        $youtubeActions.prependTo(this);

        // always remove the "remove" button for the time being
        removeRemoveButton($youtubeActions);

        // don't include links and buttons to YouTube if the video doesn't exist
        if (!video.Exists) {
          removeTitleLink($youtubeActions);
          removeEditButton($youtubeActions);
        }

        // otherwise, remove buttons that imply the video doesn't exist
        else {
          removeReuploadButton($youtubeActions);
        }

        // can't remove videos is the account has changed
        if (video.UserName != userName) {
          removeRemoveButton($youtubeActions);
        }

        // don't show a tooltip if the entire title is displayed
        if (video.Title == video.ShortTitle) {
          removeTitleTitle($youtubeActions);
        }

        if (video.State == "initialized") {
          changeStatus($youtubeActions, "is queued for upload.");
        } else if (video.State == "uploading") {
          removeReuploadButton($youtubeActions);
          changeStatus($youtubeActions, "is uploading.");
        } else if (video.State == "failed") {
          changeStatus($youtubeActions, "failed to upload.");
        } else if (video.State == "processing") {
          changeStatus($youtubeActions, "is being processed.");
        } else if (video.State == "deleted") {
          changeStatus($youtubeActions, "has been removed.");
        }
      }
    });

    function htmlReplace(html, token, replacement) {
      var re = new RegExp(escapeRegExp(token), "g"),
          escapedReplacement = $("<div/>").html(replacement).text();

      return html.replace(re, escapedReplacement);
    }

    function escapeRegExp(str) {
      return str.replace(/[-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
    }

    function removeTitleTitle($node) {
      $(".youtube-actions-title", $node).removeAttr("title");
    }

    function removeTitleLink($node) {
      var html = $(".youtube-actions-title a", $node).html();

      $(".youtube-actions-title", $node).html(html);
    }

    function removeEditButton($node) {
      $(".youtube-actions-edit", $node).remove();
    }

    function removeRemoveButton($node) {
      $(".youtube-actions-remove", $node).remove();
    }

    function removeReuploadButton($node) {
      $(".youtube-actions-reupload", $node).remove();
    }

    function changeStatus($node, text) {
      $(".youtube-actions-status", $node).html(text);
    }
  });
</script>
