<?PHP
#
#   FILE:  InitiateAuthentication.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function GetLocalUri($PageName)
{
    # remove two layers of directories if in the global plugins directory,
    # otherwise remove three
    $BaseUrl = is_int(strpos(__FILE__, "local/plugins"))
        ? preg_replace('/[^\/]+\/[^\/]+\/[^\/]+\/$/', "", OurBaseUrl())
        : preg_replace('/[^\/]+\/[^\/]+\/$/', "", OurBaseUrl());

    return $BaseUrl . "index.php?P=" . $PageName;
}

# ----- MAIN -----------------------------------------------------------------

# need to get to the root directory
$Root = "../../";
$Root .= (is_int(strpos(__FILE__, "local/plugins"))) ? "../" : "";
chdir($Root);

# set up operating environment
require_once("include/StartUp.php");

$YouTube = $G_PluginManager->GetPlugin("YouTube");

# make sure the user is authorized
if (!$User->HasPriv(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN))
{
    $YouTube->Redirect(GetLocalUri("Home"));
    return;
}

# revoke authentication first, if already authenticated
if ($YouTube->IsAuthenticated())
{
    $YouTube->RevokeAuthentication();
}

# get the token URI to which the user must be redirected and redirect
$TokenUri = $YouTube->InitiateAuthentication();
$YouTube->Redirect($TokenUri);
return;
