<?PHP
#
#   FILE:  ResumeUpload.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function LaunchTsr()
{
    # set needed headers and
    ignore_user_abort(TRUE);
    header("Connection: close");
    header("Content-Length: 0");

    # flush any buffered content
    ob_end_flush();
    flush();

    # write out any outstanding data and end HTTP session
    session_write_close();
}

function Error($Message)
{
    print "<p><b>Error:</b> " . $Message . "</p>";
}

# ----- MAIN -----------------------------------------------------------------

# need to get to the root directory
$Root = "../../";
$Root .= (is_int(strpos(__FILE__, "local/plugins"))) ? "../" : "";
chdir($Root);

# set up operating environment
require_once("include/StartUp.php");

if (!array_key_exists("UploadId", $_GET))
{
    Error("No upload ID specified");
    return;
}

$UploadId = intval($_GET["UploadId"]);

try
{
    $Upload = new YouTube_Upload($UploadId);
}
catch (YouTube_UploadDoesNotExistException $Exception)
{
    Error("Invalid upload ID");
    return;
}

LaunchTsr();

$AF->SignalEvent("YOUTUBE_DIRECT_RESUME", array($Upload));
