<?PHP

class YouTube_Exception extends Exception
{

    /**
     * In addition to superclass definition, save an optional value.
     * @param $Value optional value to store
     * @param $Message optional exception message
     * @param $Code optional error code
     * @param $Previous optional previous exception object
     */
    public function __construct($Value=NULL, $Message='', $Code=0,
        Exception $Previous=NULL)
    {
        if (version_compare(PHP_VERSION, "5.3.0") >= 0)
        {
            parent::__construct($Message, $Code, $Previous);
        }

        else
        {
            parent::__construct($Message, $Code);
        }

        $this->Value = $Value;
    }

    /**
     * Get the stored value.
     * @return the stored value
     */
    public function GetValue()
    {
        return $this->Value;
    }

    /**
     * @var $Value stored value
     */
    private $Value;

}
