<?PHP

/**
 * Class for an immutable struct. Struct data members should be declared as
 * protected in subclasses.
 */
abstract class YouTube_ImmutableStruct implements IteratorAggregate
{

    /**
     * Populate the struct with the given array values. A value will only be
     * used if its key has the same name as one of the protected properties
     * of the subclass.
     * @param $Values array values with which to populate the struct
     */
    public function __construct(array $Values)
    {
        foreach ($Values as $Name => $Value)
        {
            if (property_exists($this, $Name))
            {
                $this->$Name = $Value;
            }
        }
    }

    /**
     * Allow access to a protected property value.
     * @param $Name protected property name
     * @return the value of the protected property
     */
    public function __get($Name)
    {
        # isset() is used to avoid using property_exists() if possible
        if (!isset($this->$Name) && !property_exists($this, $Name))
        {
            throw new YouTube_PropertyDoesNotExistException($Name);
        }

        return $this->$Name;
    }

    /**
     * Allow iteration of the struct's values.
     * @return an ArrayIterator object containing the struct's properties
     */
    public function getIterator()
    {
        return new ArrayIterator(get_object_vars($this));
    }

}
