<?PHP

class YouTube_Upload implements IteratorAggregate
{

    /**
     * Create a new upload.
     * @param $File File object
     * @param $UploadUrl upload URL
     * @return a YouTube_Upload object
     */
    public static function Create(File $File, $UploadUrl)
    {
        $Database = new Database();

        # get the next ID
        $Database->Query("SELECT MAX(UploadId) AS Id FROM YouTube_UploadQueue");
        $UploadId = ($Database->NumRowsSelected()) ?
            intval($Database->FetchField("Id"))+1 : 1;

        # insert a new record into the database
        $Database->Query("
            INSERT INTO YouTube_UploadQueue
            SET UploadId = '".addslashes($UploadId)."',
            ResourceId = '".addslashes($File->ResourceId())."',
            FileId = '".addslashes($File->Id())."',
            UploadUrl = '".addslashes($UploadUrl)."',
            LastPid = '0',
            PercentComplete = '0',
            StartTime = NOW(),
            LastUpdate = NOW()");

        # return the new upload
        return new YouTube_Upload($UploadId);
    }

    /**
     * Fetch the values from the database.
     * @throws YouTube_UploadDoesNotExistException if the upload ID is invalid
     */
    public function __construct($UploadId)
    {
        $this->Database = new Database();

        # fetch associated data
        $this->Database->Query("
            SELECT *
            FROM YouTube_UploadQueue
            WHERE UploadId = '".addslashes($UploadId)."'");

        if (!$this->Database->NumRowsSelected())
        {
            throw new YouTube_UploadDoesNotExistException($UploadId);
        }

        # populate the object
        $this->Fields = $this->Database->FetchRow();
    }

    /**
     * Allow read-only access to the fields and make them look as if they're
     * data members.
     * @param $Name field name
     * @return field value
     * @throws YouTube_PropertyDoesNotExistException if the field does not exist
     */
    public function __get($Name)
    {
        if (!array_key_exists($Name, $this->Fields))
        {
            throw new YouTube_PropertyDoesNotExistException();
        }

        if (preg_match('/Id$/', $Name))
        {
            return intval($this->Fields[$Name]);
        }

        return $this->Fields[$Name];
    }

    /**
     * Delete the upload.
     */
    public function Delete()
    {
        $this->Database->Query("
            DELETE FROM YouTube_UploadQueue
            WHERE UploadId = '".addslashes($this->UploadId)."'");
    }

    /**
     * Determine if the video upload is in progress.
     * @return TRUE if the upload is in progress, FALSE otherwise
     */
    public function InProcessing()
    {
        # see if the process is still running
        $Argument = escapeshellarg($this->LastPid);
        exec("ps -p " . $Argument, $Output, $Return);

        # if the process isn't running, then the video upload is not in progress
        if ($Return === 1)
        {
            return FALSE;
        }

        $MaxExecutionBuffer = 30;
        $MaxExecutionTime = ini_get("max_execution_time") + $MaxExecutionBuffer;
        $ElapsedTime = time() - strtotime($this->LastUpdate);

        # otherwise, check if the process is past its max execution time in case
        # the process hangs for whatever reason
        return $ElapsedTime < $MaxExecutionTime;
    }

    /**
     * Set the percent complete value.
     * @param $Value percent complete
     */
    public function SetPercentComplete($Value)
    {
        $SaneValue = intval($Value) % 101;

        $this->UpdateValue("PercentComplete", $SaneValue);
        $this->UpdateLastUpdate();
    }

    /**
     * Update the last PID value to the PID of the current process.
     */
    public function UpdateLastPid()
    {
        $this->UpdateValue("LastPid", getmypid());
        $this->UpdateLastUpdate();
    }

    /**
     * Update the last time the upload was updated.
     */
    public function UpdateLastUpdate()
    {
        $this->Database->Query("
            UPDATE YouTube_UploadQueue
            SET LastUpdate = NOW()
            WHERE UploadId = '".$this->UploadId."'");
    }

    /**
     * Method required when implementing IteratorAggregate to return an iterator
     * for the class
     * @param an ArrayIterator object
     */
    public function getIterator()
    {
        return new ArrayIterator($this->Fields);
    }

    /**
     * Update a field in the database and the saved fields in the object.
     * @param $Name field name
     * @param $Value new value
     * @return the new value
     */
    private function UpdateValue($Name, $Value)
    {
        return $this->Database->UpdateValue(
            "YouTube_UploadQueue",
            $Name,
            $Value,
            "UploadId = '".intval($this->UploadId)."'",
            $this->Fields);
    }

    /**
     * @var $Database Axis Database object
     * @var $Fields database field/value pairs
     */
    private $Database;
    private $Fields;

}
