<?PHP

class YouTube_UploadFactory extends ItemFactory
{

    /**
     * Give the superclass info about the uploads table.
     */
    public function __construct()
    {
        parent::ItemFactory("YouTube_Upload", "YouTube_UploadQueue", "UploadId");
    }

    /**
     * Get the YouTube_Upload associated with the given file.
     * @param $File File object
     * @return a YouTube_Upload object
     * @throws YouTube_UploadDoesNotExistException if the upload does not exist
     */
    public function GetUploadForFile(File $File)
    {
        $Uploads = $this->GetItems("FileId = '".addslashes($File->Id())."'");

        if (!count($Uploads))
        {
            throw new YouTube_UploadDoesNotExistException();
        }

        return array_shift($Uploads);
    }

    /**
     * Get all uploads optionally filtered by the given SQL WHERE clause.
     * @param $Where optional SQL WHERE clause
     * @return an array of YouTube_Upload objects
     */
    public function GetItems($Sql=NULL)
    {
        $ItemIds = parent::GetItemIds($Sql);
        $Items = array();

        foreach ($ItemIds as $Id)
        {
            $Items[$Id] = new YouTube_Upload($Id);
        }

        return $Items;
    }

    /**
     * Determine if an upload associated to the given File object exists in the
     * table.
     * @param $File File object
     * @return TRUE if an upload exists, FALSE otherwise
     */
    public function FileExists(File $File)
    {
        $Uploads = $this->GetItems("FileId = '".addslashes($File->Id())."'");
        return count($Uploads) ? TRUE : FALSE;
    }

}
