<?PHP

class YouTube_Video
{

    /**
     * Create a new video.
     * @param $File File object
     * @return a YouTube_Video object
     */
    public static function Create(File $File)
    {
        $Database = new Database();

        # get the next ID
        $Database->Query("SELECT MAX(VideoId) AS VideoId FROM YouTube_Videos");
        $VideoId = ($Database->NumRowsSelected()) ?
            intval($Database->FetchField("VideoId"))+1 : 1;

        # insert a new record into the database
        $Database->Query("
            INSERT INTO YouTube_Videos
              (VideoId,
               ResourceId,
               FieldId,
               FileId,
               State)
            VALUES
              ('".addslashes($VideoId)."',
               '".addslashes($File->ResourceId())."',
               '".addslashes($File->FieldId())."',
               '".addslashes($File->Id())."',
               'initialized')");

        # return the new video
        return new YouTube_Video($VideoId);
    }

    /**
     * Fetch the values from the database.
     * @throws YouTube_VideoDoesNotExistException if the video ID is invalid
     */
    public function __construct($VideoId)
    {
        $this->Database = new Database();

        # fetch associated data
        $this->Database->Query("
            SELECT *
            FROM YouTube_Videos
            WHERE VideoId = '".addslashes($VideoId)."'");

        if (!$this->Database->NumRowsSelected())
        {
            throw new YouTube_VideoDoesNotExistException($VideoId);
        }

        # populate the object
        $this->Fields = $this->Database->FetchRow();
    }

    /**
     * Allow read-only access to the fields and make them look as if they're
     * data members.
     * @param $Name field name
     * @return field value
     * @throws YouTube_PropertyDoesNotExistException if the field does not exist
     */
    public function __get($Name)
    {
        if (!array_key_exists($Name, $this->Fields))
        {
            throw new YouTube_PropertyDoesNotExistException();
        }

        if (preg_match('/^(Video|File)Id$/', $Name))
        {
            return intval($this->Fields[$Name]);
        }

        return $this->Fields[$Name];
    }

    /**
     * Get the resource associated with this video.
     * @return a Resource object
     */
    public function GetResource()
    {
        return new Resource($this->ResourceId);
    }

    /**
     * Get the metadata field associated with this video.
     * @return a MetadataField object
     */
    public function GetField()
    {
        $Schema = new MetadataSchema();
        return $Schema->GetField($this->FieldId);
    }

    /**
     * Get the file associated with this video.
     * @return a File object
     */
    public function GetFile()
    {
        return new File($this->FileId);
    }

    /**
     * Set the title for the video. This should only be used to cache the
     * actual video title from a video entry.
     * @param $Title video title
     */
    public function SetTitle($Title)
    {
        $this->UpdateValue("Title", $Title);
    }

    /**
     * Set the description for the video. This should only be used to cache
     * the actual video description from a video entry.
     * @param $Description video description
     */
    public function SetDescription($Description)
    {
        $this->UpdateValue("Description", $Description);
    }

    /**
     * Set the YouTube ID for the video.
     * @param $YouTubeId YouTube video ID
     */
    public function SetYouTubeId($YouTubeId)
    {
        $this->UpdateValue("YouTubeId", $YouTubeId);
    }

    /**
     * Set the user name for the video.
     * @param $UserName user name
     */
    public function SetUserName($UserName)
    {
        $this->UpdateValue("UserName", $UserName);
    }

    /**
     * Flag the video as initialized.
     */
    public function FlagAsInitialized()
    {
        $this->UpdateValue("State", "initialized");
    }

    /**
     * Flag the video as uploading.
     */
    public function FlagAsUploading()
    {
        $this->UpdateValue("State", "uploading");
    }

    /**
     * Flag the video as failed.
     */
    public function FlagAsFailed()
    {
        $this->UpdateValue("State", "failed");
    }

    /**
     * Flag the video as processing.
     */
    public function FlagAsProcessing()
    {
        $this->UpdateValue("State", "processing");
    }

    /**
     * Flag the video as ready.
     */
    public function FlagAsReady()
    {
        $this->UpdateValue("State", "ready");
    }

    /**
     * Flag the video as deleted.
     */
    public function FlagAsDeleted()
    {
        $this->UpdateValue("State", "deleted");
    }

    /**
     * Get the HTML necessary to embed the video.
     * @param $Class optional HTML class
     * @param $Width optional iframe width
     * @param $Height optional iframe height
     * @return HTML text
     */
    public function GetHtml($Class=NULL, $Width=480, $Height=320)
    {
        $YouTubeId = $this->YouTubeId;
        $Text = '<iframe class="' . $Class .'" type="text/html" width="'
                . $Width . '" height="' . $Height . '" src="http://www.youtube.com/embed/'
                . $YouTubeId . '" frameborder="0" title="YouTube Video"></iframe>';

        return $Text;
    }

    /**
     * Delete the video.
     */
    public function Delete()
    {
        $this->Database->Query("
            DELETE FROM YouTube_Videos
            WHERE VideoId = '".addslashes($this->VideoId)."'");
    }

    /**
     * Update a field in the database and the saved fields in the object.
     * @param $Name field name
     * @param $Value new value
     * @return the new value
     */
    private function UpdateValue($Name, $Value)
    {
        return $this->Database->UpdateValue(
            "YouTube_Videos",
            $Name,
            $Value,
            "VideoId = '".addslashes($this->VideoId)."'",
            $this->Fields);
    }

    /**
     * @var $Database Axis Database object
     * @var $Fields database field/value pairs
     */
    private $Database;
    private $Fields;

}
