<?PHP

class YouTube_VideoFactory extends ItemFactory
{

    /**
     * Give the superclass info about the uploads table.
     */
    public function __construct()
    {
        parent::ItemFactory("YouTube_Video", "YouTube_Videos", "VideoId");
    }

    /**
     * Get the YouTube_Video objects associated with the given resource.
     * @param $Resource Resource object
     * @return an array of YouTube_Video objects
     */
    public function GetVideosForResource(Resource $Resource)
    {
        return $this->GetItems("ResourceId = '".addslashes($Resource->Id())."'");
    }

    /**
     * Get the YouTube_Video associated with the given file.
     * @param $File File object
     * @return a YouTube_Video object
     * @throws YouTube_VideoDoesNotExistException if the video does not exist
     */
    public function GetVideoForFile(File $File)
    {
        $Videos = $this->GetItems("FileId = '".addslashes($File->Id())."'");

        if (!count($Videos))
        {
            throw new YouTube_VideoDoesNotExistException();
        }

        return array_shift($Videos);
    }

    /**
     * Get all videos optionally filtered by the given SQL WHERE clause.
     * @param $Sql optional SQL WHERE clause
     * @return an array of YouTube_Video objects
     */
    public function GetItems($Sql=NULL)
    {
        $ItemIds = parent::GetItemIds($Sql);
        $Items = array();

        foreach ($ItemIds as $Id)
        {
            $Items[$Id] = new YouTube_Video($Id);
        }

        return $Items;
    }

    /**
     * Determine if an upload associated to the given File object exists in the
     * table.
     * @param $File File object
     * @return TRUE if an upload exists, FALSE otherwise
     */
    public function FileExists(File $File)
    {
        $Videos = $this->GetItems("FileId = '".addslashes($File->Id())."'");
        return count($Videos) ? TRUE : FALSE;
    }

}
