<?PHP

class YouTube_Zend_Gdata_HttpClient extends Zend_Gdata_HttpClient
{

    /**
     * @const CONTENT_RANGE HTTP header key for content range
     */
    const CONTENT_RANGE = 'Content-Range';

    /**
     * This does the same thing as the class it extends except it takes into
     * account that if $data is a resource, its file pointer might not be at the
     * beginning of the resource. Thus, the Content-Length header is adjusted
     * and the Content-Range header added whenever the file pointer is not at
     * the beginning of the resource.
     * @param string|resource $data
     * @param string $enctype
     * @return Zend_Http_Client
     */
    public function setRawData($data, $enctype = null)
    {
        parent::setRawData($data, $enctype);

        // update Content-Length since Zend_Http_Client doesn't use ftell and
        // the file pointer might not be at the beginning of the file
        if (is_resource($data)) {
            // We've got stream data
            $stat = @fstat($data);
            $offset = @ftell($data);

            if ($stat && $offset) {
                // set the Content-Length header based on how much data will
                // be sent
                $length = $stat['size'] - $offset;
                $this->setHeaders(self::CONTENT_LENGTH, $length);

                // if only a partial amount of the file will be uploaded, also
                // include the Content-Range header
                if ($offset != 0) {
                    $total = $stat['size'];
                    $first = $offset;
                    $last = $total - 1;
                    $range = "bytes $first-$last/$total";

                    $this->setHeaders(self::CONTENT_RANGE, $range);
                }
            }
        }

        return $this;
    }

}
