<?PHP

class YouTube_Zend_Http_Client_Adapter_Socket extends Zend_Http_Client_Adapter_Socket
{

    /**
     * @const BUFFER_SIZE how much content to buffer and send per stream copy
     */
    const BUFFER_SIZE = 1280000;

    /**
     * @var $upload YouTube_Upload object that will be updated while uploading
     */
    protected $upload;

    /**
     * Set the YouTube_Upload object to update while sending a file.
     * @param $Upload a YouTube_Upload object
     */
    public function setUpload(YouTube_Upload $upload)
    {
        $this->upload = $upload;
    }

    /**
     * Same as the superclass method it extends, also updates the stored
     * YouTube_Upload object's PercentComplete field while sending data, if
     * stored.
     * @param string        $method
     * @param Zend_Uri_Http $uri
     * @param string        $http_ver
     * @param array         $headers
     * @param string        $body
     * @return string Request as string
     */
    public function write($method, $uri, $http_ver = '1.1', $headers = array(), $body = '')
    {
        // Make sure we're properly connected
        if (! $this->socket) {
            require_once 'Zend/Http/Client/Adapter/Exception.php';
            throw new Zend_Http_Client_Adapter_Exception('Trying to write but we are not connected');
        }

        $host = $uri->getHost();
        $host = (strtolower($uri->getScheme()) == 'https' ? $this->config['ssltransport'] : 'tcp') . '://' . $host;
        if ($this->connected_to[0] != $host || $this->connected_to[1] != $uri->getPort()) {
            require_once 'Zend/Http/Client/Adapter/Exception.php';
            throw new Zend_Http_Client_Adapter_Exception('Trying to write but we are connected to the wrong host');
        }

        // Save request method for later
        $this->method = $method;

        // Build request headers
        $path = $uri->getPath();
        if ($uri->getQuery()) $path .= '?' . $uri->getQuery();
        $request = "{$method} {$path} HTTP/{$http_ver}\r\n";
        foreach ($headers as $k => $v) {
            if (is_string($k)) $v = ucfirst($k) . ": $v";
            $request .= "$v\r\n";
        }

        if(is_resource($body)) {
            $request .= "\r\n";
        } else {
            // Add the request body
            $request .= "\r\n" . $body;
        }

        // Send the request
        if (! @fwrite($this->socket, $request)) {
            require_once 'Zend/Http/Client/Adapter/Exception.php';
            throw new Zend_Http_Client_Adapter_Exception('Error writing request to server');
        }

        if(is_resource($body)) {
            if (isset($this->upload)) {
              $upload = $this->upload;
              $stat = @fstat($body);

              if ($stat === FALSE) {
                // fstat failed, so just try to send all of the file at once
                if (stream_copy_to_stream($body, $this->socket) == 0) {
                  require_once 'Zend/Http/Client/Adapter/Exception.php';
                  throw new Zend_Http_Client_Adapter_Exception('Error writing request to server');
                }
              } else {
                $size = $stat['size'];
                $offset = $size - 1;
                $upload->UpdateLastPid();

                do {
                  $total = @stream_copy_to_stream(
                    $body,
                    $this->socket,
                    self::BUFFER_SIZE);

                  $pointer = @ftell($body);

                  if ($pointer === FALSE) {
                    // ftell failed, so just try to send the rest of the file at
                    // once
                    if (stream_copy_to_stream($body, $this->socket) == 0) {
                      require_once 'Zend/Http/Client/Adapter/Exception.php';
                      throw new Zend_Http_Client_Adapter_Exception('Error writing request to server');
                    }

                    // break the loop
                    break;
                  }

                  $complete = round(100 * $pointer / $offset);
                  $upload->SetPercentComplete($complete);
                } while ($pointer < $size);
              }
            } else if (stream_copy_to_stream($body, $this->socket) == 0) {
                require_once 'Zend/Http/Client/Adapter/Exception.php';
                throw new Zend_Http_Client_Adapter_Exception('Error writing request to server');
            }
        }

        return $request;
    }

}
