<?php

#
#   FILE:  SPT--AddResourceComment.php
#
#   FUNCTIONS PROVIDED:
#       PrintTitle()
#       - print the resource title
#
#       PrintBody()
#       - print the body of the comment
#
#       PrintSubject()
#       - print subject of comment
#
#       CheckForEdit()
#       - check to see if editing a resource
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Message.php");
require_once("include/SPT--Resource.php");

PageTitle("Add Resource Comment");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print the Title
function PrintTitle()
{
    global $Resource;

    print $Resource->Get("Title");
}

# print body
function PrintBody()
{
    global $F_Body;

    # filter out "Edited by:" text
    $loc = strpos($F_Body, "<br>");
    if($loc === false)
        print GetHtmlEscapedString($F_Body);
    else
        print GetHtmlEscapedString(substr($F_Body, 0, $loc - 2));  
} 

# print body
function PrintSubject()
{
    global $F_Subject;

    print GetHtmlEscapedString($F_Subject);
} 

function CheckForEdit()
{
    global $MessageId, $User, $PosterId;

    if(isset($MessageId) && ($User->Get("UserId") == $PosterId ||
        $User->HasPriv(PRIV_SYSADMIN)))
        return true;
    else
        return false;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# do the query for this resource
$ResourceId = $HTTP_GET_VARS["ResourceId"];
$Resource = & new Resource($ResourceId);

if(!empty($HTTP_GET_VARS["messageid"]))
{
    $MessageId = $HTTP_GET_VARS["messageid"];
    $Message =& new Message($MessageId);
    $F_Subject = $Message->Subject();
    $F_Body = $Message->Body();
    $PosterId = $Message->PosterId();
}
else
{
    $MessageId = NULL;
    $F_Subject = $Resource->Get("Title");
}

# pass along necessary variables 
$Session->PassVariable("ResourceId", $ResourceId);
$Session->PassVariable("ParentId", $ResourceId);
$Session->PassVariable("F_Subject", GetHtmlEscapedString($F_Subject));
$Session->PassVariable("MessageId", $MessageId);

CheckAuthorization(PRIV_POSTCOMMENTS);
include("include/SPT--StandardHtmlPageLoad.php");

?>
