<?php
#
#   FILE:  SPT--AddTopic.php
#
#   FUNCTIONS PROVIDED:
#       PrintForumId()
#       PrintForumName()
#       PrintErrorMessages()
#       DisplayTopics()
#
#   FUNCTIONS EXPECTED:
#       DisplayAddButtons()
#           - display add, delete, cancel buttons
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Forum.php");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintForumId()
{
    global $ForumId;

    print $ForumId;
}

function PrintForumName()
{
    global $ForumName;

    print stripslashes($ForumName);
}

function PrintTopic()
{
    global $F_TopicName;

    print stripslashes($F_TopicName);
}

function PrintSubject()
{
    global $F_Subject;

    print GetHtmlEscapedString($F_Subject);
}

function PrintBody()
{
    global $F_Body;

    print GetHtmlEscapedString($F_Body);
}

# print out any error messages
function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed 
    if (count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

if(isset($HTTP_GET_VARS["forumid"]))
    $ForumId = $HTTP_GET_VARS["forumid"];
else
    $ForumId = $Session->Get("forumid");
$Forum =& new Forum($ForumId);
$ForumName = $Forum->ForumName();

if(isset($HTTP_POST_VARS["F_TopicName"]))
    $F_TopicName = $HTTP_POST_VARS["F_TopicName"];
else
    $F_TopicName = $Session->Get("F_TopicName");
if(isset($HTTP_POST_VARS["F_Subject"]))
    $F_Subject = $HTTP_POST_VARS["F_Subject"];
else
    $F_Subject = $Session->Get("F_Subject");
if(isset($HTTP_POST_VARS["F_Body"]))
    $F_Body = $HTTP_POST_VARS["F_Body"];
else
    $F_Body = $Session->Get("F_Body");

PageTitle("Add Topic");
CheckAuthorization(PRIV_FORUMADMIN);
include("include/SPT--StandardHtmlPageLoad.php");

?>
