
-- list of search words
CREATE TABLE SearchWords (
    WordId          INT NOT NULL AUTO_INCREMENT,
    WordText        TEXT,
    INDEX           (WordText(16)),
    INDEX           (WordId)
);

-- lookup table for counts of word occurences
CREATE TABLE SearchWordCounts (
    WordId          INT NOT NULL,
    ItemId          INT NOT NULL,
    FieldId         SMALLINT NOT NULL,
    Count           SMALLINT,
    INDEX           (WordId, FieldId, ItemId)
);

-- list of search fields
CREATE TABLE SearchFields (
    FieldId             SMALLINT NOT NULL AUTO_INCREMENT,
    FieldName           TEXT,
    FieldLocation       INT,
    INDEX               (FieldId)
);

