#!/usr/bin/php
<?PHP 
# Unit tester for Axis--Date object

require_once('Axis--Date--crh.php');

# Adds leading zeros to months and days
function lz($data)
{
  return (($data<10)?"0":"").$data ;
}


# FormatDate -- Generate one of the formats that Axis--Date should be able to parse
# $FmtNo -- a format number :
# ( 0) 1999-9
# ( 1) Sep-1999
# ( 2) Sep 1999
# ( 3) 199909
# ( 4) 1999-9-19
# ( 5) 9-19-1999
# ( 6) 19-9-1999
# ( 7) Sep 9 1999
# ( 8) September 9th, 1999
# ( 9) 9/19/99
# (10) 9-19-99
# (11) 19990919
# (12) 09-Sep-1999
# (13) 09 Sep 1999
# (14) c1999

function FormatDate( $FmtNo, $Year, $Month, $Day )
{
  $MonthNames = array (
     1 => "January",
     2 => "February",
     3 => "March",
     4 => "April",
     5 => "May",
     6 => "June",
     7 => "July",
     8 => "August",
     9 => "September",
    10 => "October",
    11 => "November",
    12 => "December"
  );

  $LongMonthName  = $MonthNames[$Month];
  $ShortMonthName = substr($LongMonthName,0,3);
  
  # Suffix for long-form month numbers
  $Sfx = ($Day % 10) == 1 ? "st" :
         ($Day % 10) == 2 ? "nd" :
         ($Day % 10) == 3 ? "rd" : "th";
  $Values = array ( 
    $Year."-".$Month,
    $ShortMonthName."-".$Year,
    $ShortMonthName." ".$Year,
    $Year.lz($Month),
    $Year."-".$Month."-".$Day,
    $Month."-".$Day."-".$Year,
    $Day."-".$Month."-".$Year,
    $ShortMonthName." ".$Day." ".$Year,
    $LongMonthName." ".$Day.$Sfx.", ".$Year,
    $Month."/".$Day."/".substr($Year,2),
    $Month."-".$Day."-".substr($Year,2),
    $Year.lz($Month).lz($Day),
    lz($Day)."-".$ShortMonthName."-".$Year,
    lz($Day)." ".$ShortMonthName." ".$Year,
    "c".$Year,
  );

  return $Values[$FmtNo];
}

$NumberOfFormats = 13;

$ExitStatus = 0 ;

# We want to test years both above and below 2000
foreach ( array(1999,2001) as $Year )
{
  # Test each month, to make sure that none of the long/short name parsing is
  # messed up for a particular month.
  for ( $Month = 1; $Month <= 12; $Month++ )
  {
    # We don't need to test every day of every month
    # 1-4 will have different suffixes in the long-format (1st, 2nd, etc)
    # so those should be tested.
    # We should be testing both single and double-digit dates
    # 1-4,15 should exercise all the important parts.
    foreach( array(1,2,3,4,15,21,22,23) as $Day )
    {
      # Index through each of the formats.
      for ( $Ix=0; $Ix<=$NumberOfFormats; $Ix++)
      {
  
        # Try parsing a single date: 
        $TestValue = FormatDate( $Ix, $Year, $Month, $Day );
        $TestDate = new Date($TestValue);
        $Parsed = $TestDate->BeginDate();
  
        # Construct the expected result
        $Expected = $Year."-".lz($Month)."-".(($Ix<=3)?"00":lz($Day));
        if( $Parsed != $Expected )
        {
          # We expect to fail on D-M-Y when D<=12, because we can't 
          # Distinguish that from M-D-Y
          if( $Ix == 6 && $Day <= 12 )
          {
            print("Exfail Parsing '".$TestValue."': "
                  ."Expected '".$Expected."' but got '".$Parsed."'\n");
          }
          else 
          {
            $ExitStatus = 1 ;
            print("FAIL Parsing '".$TestValue."': "
                  ."Expected '".$Expected."' but got '".$Parsed."'\n");
          }
        }
        
        # Now for a date range
        # Try an end date in each possible format
        # We'll go from the starting date till 2 years later.
        for( $Ix2 = 0; $Ix2<=$NumberOfFormats; $Ix2++ )
        {
          $TestValue = FormatDate( $Ix,  $Year,   $Month, $Day ) . " - " .
                       FormatDate( $Ix2, $Year+2, $Month, $Day );
          $TestDate = new Date($TestValue);
          $Parsed = $TestDate->BeginDate()." - ".$TestDate->EndDate();
        
          $Expected =     $Year."-".lz($Month)."-".(($Ix <=3)?"00":lz($Day))." - ".
                      ($Year+2)."-".lz($Month)."-".(($Ix2<=3)?"00":lz($Day));
          if( $Parsed != $Expected )
          {
            if( ($Ix == 6 || $Ix2 == 6 )  && $Day <= 12 )
            {
                # Again, expected failures on D-M-Y when D<=12
                print("Exfail Parsing '".$TestValue."': "
                      ."Expected '".$Expected."' but got '".$Parsed."'\n");
            }
            else 
            {
               $ExitStatus = 1 ;
                print("FAIL Parsing '".$TestValue."': "
                      ."Expected '".$Expected."' but got '".$Parsed."'\n");
            }
          }
        }
      }
    }
  }
}

# If any tests failed, exit with an error.
exit ($ExitStatus) ;
?>
