<?php
#
#   FILE:  SPT--DBEditor.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

PageTitle("Metadata Field Editor");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintTextFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();
    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_TEXT, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintTextFieldRow($Field);
    }
}

function PrintParagraphFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_PARAGRAPH, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintParagraphFieldRow($Field);
    }
}

function PrintNumberFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_NUMBER, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintNumberFieldRow($Field);
    }
}

function PrintPointFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_POINT, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintPointFieldRow($Field);
    }
}

function PrintDateFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_DATE, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintDateFieldRow($Field);
    }
}

function PrintTimestampFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_TIMESTAMP, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintTimestampFieldRow($Field);
    }
}

function PrintFlagFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_FLAG, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintFlagFieldRow($Field);
    }
}

function PrintTreeFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_TREE, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintTreeFieldRow($Field);
    }
}

function PrintContolledNameFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_CONTROLLEDNAME, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintControlledNameFieldRow($Field);
    }
}

function PrintOptionFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_OPTION, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintOptionFieldRow($Field);
    }
}

function PrintUserFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_USER, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintUserFieldRow($Field);
    }
}

function PrintImageFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_IMAGE, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintImageFieldRow($Field);
    }
}

function PrintFileFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_FILE, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintFileFieldRow($Field);
    }
}

function PrintUrlFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();
    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_URL, 
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintUrlFieldRow($Field);
    }
}

function PrintDefaultValue($Field)
{
    if ($Field->DefaultValue())
        print $Field->DefaultValue();
    else
        print "[No default value entered for this field]";
}

function PrintHasItemLevelQualifiers($Field)
{
    print GetYesNo($Field->HasItemLevelQualifiers());
}

function PrintDefaultQualifier($Field)
{
    $DefaultQualifier = $Field->DefaultQualifier();
    if ($DefaultQualifier > 0)
    {
        $Qualifier = new Qualifier($Field->DefaultQualifier());
        print $Qualifier->Name();
    }
    else
        print "--";
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# translate 1=Yes, 0=No
function GetYesNo($Var)
{
    return ($Var ? "Yes" : "No");
}

# translate flag on or flag off label
function GetFlagValue($Field)
{
    return ($Field->DefaultValue() ? $Field->FlagOnLabel() :
                $Field->FlagOffLabel());
}

# ----- MAIN -----------------------------------------------------------------

?>
