<?PHP

require_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# functions to return sys config info (for insertion into forms)
function PrintClassificationTypes()
{
    global $SysConfig;

    # print option list for UI
    $Schema = new MetadataSchema();
    $FieldNames = $Schema->GetFieldNames(MetadataSchema::MDFTYPE_TREE);
    PrintOptionList("F_BrowsingFieldId", $FieldNames,
                    $SysConfig->BrowsingFieldId(),
                    FALSE, 1, NULL, FALSE);
}

function PrintCheckedWhen($Option, $Value)
{
    global $SysConfig;
    if ($SysConfig->{$Option}() == $Value){ print("checked"); }
}

function PrintCheckedIf($Option)
{
    global $SysConfig;
    if ($SysConfig->{$Option}()) {  print("checked");  }
}
function PrintCheckedIfNot($Option)
{
    global $SysConfig;
    if (!$SysConfig->{$Option}()) {  print("checked");  }
}

function PrintCheckedIfSearchTermHandlingIsAnd()
{
    global $SysConfig;
    if ($SysConfig->SearchTermsRequired()) {  print("checked");  }
}
function PrintCheckedIfSearchTermHandlingIsOr()
{
    global $SysConfig;
    if (!$SysConfig->SearchTermsRequired()) {  print("checked");  }
}
function PrintCheckedIfReleaseFlagApproved()
{
    global $SysConfig;
    if ($SysConfig->ReleaseFlagApproved()) {  print("checked");  }
}
function PrintCheckedIfReleaseFlagNotApproved()
{
    global $SysConfig;
    if (!$SysConfig->ReleaseFlagApproved()) {  print("checked");  }
}

function PrintGoogleAnalyticsCode()
{
    global $SysConfig;
    print($SysConfig->GoogleAnalyticsCode());
}

function PrintActiveUIOptionList()
{
    global $SysConfig;

    # print option list for UI
    print(GetActiveUIOptionList($SysConfig->DefaultActiveUI()));
}

function PrintCharacterSetOptionList()
{
    global $SysConfig;

    # print option list for character coding
    $CharSets = array("ISO-8859-1", "UTF-8");

    $Text = "";
    foreach ($CharSets as $CharSet)
    {
        if ($SysConfig->DefaultCharacterSet() == $CharSet)
            $Select = " selected";
        else
            $Select = NULL;

        $Text .= "<option value=\"$CharSet\"$Select>$CharSet</option>\n";
    }
    print($Text);
}

function PrintSiteKeywords()
{
    global $SysConfig;

    # print the keywords as stored in the SysConfig object
    print($SysConfig->SiteKeywords());
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function PrintValue($ValueName)
{
    global $SysConfig;
    global $Session;

    $FormVar = "F_".$ValueName;
    ${$FormVar} = $Session->Get($FormVar);
    if (isset(${$FormVar}))
    {
        print(${$FormVar});
        $Session->UnregisterVariable($FormVar);
    }
    else
    {
        print($SysConfig->{$ValueName}());
    }
}


# ----- MAIN -----------------------------------------------------------------

PageTitle("Edit System Configuration");
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

global $G_Schema;
$G_Schema = new MetadataSchema();

?>
