<?php
#
#   FILE:  SPT--SelectEditUserComplete.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#    ://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# confirm remove user(s)
function ConfirmRemoveUsers()
{
    global $_POST, $Session;

    reset($_POST);
    while (list($Var, $Value) = each ($_POST))
    {
        if (ereg("userid_([0-9]+)", $Var, $Regs))
        {
            if (isset($Value))
            { 
                $UserRemoveArray[] = intval($Value);
            }
        }
    }
    $Session->PassVariable("UserRemoveArray", $UserRemoveArray);
    global $AF;
    $AF->SetJumpToPage("ConfirmRemoveUser");
}

# remove user(s) 
function RemoveUsers()
{
    global $Session;
    global $AF;

    $DB = new SPTDatabase();

    $UserRemoveArray = $Session->Get("UserRemoveArray");
    foreach ($UserRemoveArray as $UserId)
    {
        $RemoveUser = new User($DB, intval($UserId));
        $AF->SignalEvent("EVENT_USER_DELETED", array("UserId" => $RemoveUser->Id()));
        $RemoveUser->Delete();
    }
    global $AF;
    $AF->SetJumpToPage("SelectEditUser");
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $_POST;

if (!CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN)) {  return;  }

# grab entry information from database
$DB = new SPTDatabase();

$Submit = $_POST["Submit"];

# check for Cancel button from previous screen
if ($Submit == "Cancel")
{
    $AF->SetJumpToPage("SelectEditUser");
}
else if (substr($Submit, 0, 6) == "Remove")
{
    # OK to remove selected user?
    if ($Session->Get("OkayToRemove"))
    {
        RemoveUsers();
    }
    # build array list of users to remove
    else
    {
        ConfirmRemoveUsers();
    }
}

?>
