<?PHP

if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

PageTitle("Task Queue");

# refresh the page every 30 seconds
header("Refresh: 30; url=".OurBaseUrl()."index.php?P=".$_GET["P"]);

# if action requested
if (isset($_GET["AC"]))
{
    # re-queue orphaned task if requested
    $TaskId = intval($_GET["ID"]);
    if ($_GET["AC"] == "REQUEUE")
    {
        $GLOBALS["AF"]->ReQueueOrphanedTask($TaskId);
    }
    # remove orphaned task if requested
    elseif ($_GET["AC"] == "DELETE")
    {
        $GLOBALS["AF"]->DeleteOrphanedTask($TaskId);
    }
    # remove task in foreground if requested
    elseif ($_GET["AC"] == "RUN")
    {
        # retrieve orphaned task list
        $Orphans = $GLOBALS["AF"]->GetOrphanedTaskList();

        # if specified task found in orphan list
        if (isset($Orphans[$TaskId]))
        {
            # run task
            call_user_func_array(
                    $Orphans[$TaskId]["Callback"], $Orphans[$TaskId]["Parameters"]);

            # remove task from orphan list
            $GLOBALS["AF"]->DeleteOrphanedTask($TaskId);
        }
    }
}

?>
