<?PHP
#
#   FILE:  Developer.php
#
#   FUNCTIONS PROVIDED:
#      (none)
#   FUNCTIONS EXPECTED:
#      (none)
#
#   OPTIONAL FUNCTIONS:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Copyright 2010 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
 * Version-agnostic htmlentities() function.
 * See: http://www.php.net/manual/en/function.htmlentities.php
 * @param $string the input string
 * @param $quote_style defines what is done with quotes
 * @param $charset defines the character set used in conversion
 * @param $double_encode when off, PHP won't encode existing HTML entities (>= 5.2.3)
 * @return the encoded string
 */
function safehtmlentities($string, $quote_style=ENT_COMPAT, $charset="ISO-8859-1", $double_encode=TRUE)
{
    # get php's version
    list($Major, $Minor, $Maint) = explode(".", phpversion());
    $Major = intval($Major);
    $Minor = intval($Minor);
    $Maint = intval($Maint);

    # ignore $double_encode param if php version < 5.2.3
    if ($Major < 5 || $Major < 6 && $Minor < 2 || $Major < 6 && $Minor < 3 && $Maint < 4)
    {
        return htmlentities($string, $quote_style, $charset);
    }

    return htmlentities($string, $quote_style, $charset, $double_encode);
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard globals
global $G_Info;
global $G_NextResourcesToBeChecked;
global $G_NextUrlsToBeChecked;

# setup
PageTitle("URL Checker Developer Page");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$G_Info = $AF->SignalEvent("URLCHECKER_GET_INFORMATION");
$G_NextResourcesToBeChecked = $AF->SignalEvent("URLCHECKER_GET_NEXT_RESOURCES_TO_BE_CHECKED");
$G_NextUrlsToBeChecked = $AF->SignalEvent("URLCHECKER_GET_NEXT_URLS_TO_BE_CHECKED");
