<?php
#
#   FILE:  SPT--AssignClassification.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Classification.php");
require_once("include/SPT--ResourceFactory.php");

CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN);

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# process selected classifications
function ProcessSelectedClassifications()
{
    global $Session, $ResourceId, $HTTP_POST_VARS;

    $DB =& new SPTDatabase();
    $NewRecordFlag = 0;
    
    reset ($HTTP_POST_VARS);
    while (list($Var, $Value) = each ($HTTP_POST_VARS))
    {
        if (ereg("class_([0-9]+)",$Var,$Regs) )
        {
            trim($Value);
            if ($Value != "")
            {
                $ClassName = $Value;
                continue;
            }
        }
        if (ereg("classid_([0-9]+)",$Var,$Regs) )
        {
            trim($Value);
            if ($Value != "")
            {
                $Resource = & new Resource($ResourceId);
                $Class = & new Classification($Value);
                $Resource->SetByFieldId($Class->FieldId(), $Value);
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

# get currently edited resource
$RFactory = & new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

if (isset($HTTP_POST_VARS["Submit"]))
    $Submit = $HTTP_POST_VARS["Submit"];
else
    $Submit = NULL;

if ($Submit != "Cancel")
    ProcessSelectedClassifications();
    
# return to Entry screen    
PrintAutoRefreshPage("Add New Record", "SPT--DBEntry.php");
?>
