<?php
#
#   FILE:  SPT--EditControlledNameComplete.php
#
#   FUNCTIONS PROVIDED:
#       DisplayControlledNameInfo()
#           - updates or deletes ControlledName fields from ControlledNames
#             and VariantNames, and updates DateLastModified for affected
#             Resources
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--ControlledName.php");
require_once("include/SPT--SearchEngine.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# display list of modified controlled names
function DisplayControlledNameList()
{
    global $CNArray;

    foreach($CNArray as $CNName => $CNVariant)
    {
        print $CNName;
        if(!empty($CNVariant))
            print ", Variant ($CNVariant)";
        print "<br>";    
    }
}

# display the list of modified resources
function DisplayModifiedResourceList()
{
    global $LinkArray;

    foreach ($LinkArray as $LinkIndex => $LinkString)
    {
        print $LinkString;
    }
}

function DisplayModifiedOrDeleted()
{
    global $Submit;

    if ($Submit == "Update Checked Values")
        print "modified";
    else
        print "deleted";
}

function ProcessControlledNames()
{
    global $F_ControlledName;
    global $HTTP_POST_VARS;
    global $Session;
    global $CNArray;
    global $Submit;

    $CNArray = array();

    $Check = 0;
    reset($HTTP_POST_VARS);
    # we assume that ControlledNameId comes before ControlledName
    while (list($Var, $Val) = each ($HTTP_POST_VARS))
    {
#        echo "$Var=$Val<br>";
        # default QualifierId to NULL
        unset($QualifierId);
        if (ereg("^F_Check_([0-9]+)",$Var,$Regs))
        {
            $Check = 1;
            continue;
        }
        if (ereg("^F_ControlledNameId_([0-9]+)",$Var,$Regs))
        {
            $ControlledNameId = $Val;
            continue;
        }
        if (ereg("^F_ControlledName_([0-9]+)",$Var,$Regs))
        {
            $ControlledName = $Val;
            $ControlledName = trim($ControlledName);
            continue;
        }
        if (ereg("^F_VariantName_([0-9]+)",$Var,$Regs))
        {
            $VariantName = $Val;
            $VariantName = trim($VariantName);
            continue;
        }
        if (ereg("^F_FieldId_([0-9]+)",$Var,$Regs))
        {
            $F_FieldId = $Val;
            $Schema = & new MetadataSchema();
            $Field = $Schema->GetField($F_FieldId);
            if ($Field->HasItemLevelQualifiers())
                continue;
        }
        if (ereg("^F_QualifierName_([0-9]+)",$Var,$Regs))
        {
            $QualifierId = $Val;
            # if "--" selected, set qualifier id = NULL
            if ($QualifierId == "--")
                $QualifierId = "NULL";
        }

#        echo "VN=$VariantName, CN=$ControlledName, CNID=$ControlledNameId<br>";
#        echo "FieldId=$F_FieldId, Check=$Check, QID=$QualifierId<br>";

        # update the values for each controlled name
        if (!empty($ControlledName) && $Check)
        {
            $CNArray[] = $ControlledNameId;

            if($Submit == "Update Checked Values")
            {
                $CN = & new ControlledName($ControlledNameId);
                $CN->Name($ControlledName);
                $CN->FieldId($F_FieldId);
                if (isset($QualifierId))
                    $CN->QualifierId($QualifierId);
                $CN->Variant($VariantName);
            }
            $Check = 0;
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# update any checked records
function UpdateCheckedValues()
{
    global $Submit;
    global $CNArray;
    global $LinkArray;

    $DB =& new SPTDatabase();
    $DB2 = & new SPTDatabase();
    $SearchEngine =& new SPTSearchEngine();
    $LinkIndex = 0;
    $LinkArray = array();
    $NewCNArray = array();

    foreach ($CNArray as $CNId)
    {
        # cache controlled name and variant for display purposes
        $CN = & new ControlledName($CNId);
        $NewCNArray[$CN->Name()] = $CN->Variant();

        # now update DateLastModified for all affected Resources if updating 
        $Query = "Select distinct Resources.ResourceId, Title from ".
             "Resources INNER JOIN ResourceNameInts ON ".
             "ResourceNameInts.ResourceId=Resources.ResourceId ".
             "WHERE ControlledNameId = $CNId ".
             "ORDER BY Resources.ResourceId";

        $DB->Query($Query);
                
        $Rows = $DB->NumRowsSelected();
        for ($Index=0; $Index<$Rows; $Index++)
        {
            $Result = $DB->FetchNextRowArray();

            $LinkArray[$LinkIndex++] = 
                "<a href=\"../SPT--FullRecord.php?ResourceId=".
                $Result["ResourceId"]." target=\"_blank\">".
                $Result["Title"]."</a><br>";
            $UpdateQuery = "Update Resources set ".
                "DateLastModified = '".date("Y-m-d H:i:s").
                "' where ResourceId = ".$Result["ResourceId"];
            $DB2->Query($UpdateQuery);

            # update the Search DB for this controlled name & resource
            $SearchEngine->UpdateForResource($Result["ResourceId"]);
        }
    }
    $CNArray = $NewCNArray;
}

# delete checked records, cache the Ids for now        
function DeleteCheckedValues()
{
    global $CNArray;
    global $Session;

    # confirm removal of options if any selected
    if (count($CNArray) > 0)
    {
        $Session->PassVariable("CNArray", $CNArray);
        PrintAutoRefreshPage("Confirm Delete Values", 
            "SPT--ConfirmDeleteControlledName.php?action=Values".
            "&target=SPT--EditControlledNameComplete.php");
        exit;
    }
}

# do the actual deletion of values 
function ConfirmDeleteValues()
{
    global $CNArray;
    global $Session;

    $CNArray = $Session->Get("CNArray");
    $CNArraySave = $CNArray;

    # update last modified for all checked records
    UpdateCheckedValues();

    # now remove each controlled name
    foreach ($CNArraySave as $CNId)
    {
        $CN = & new ControlledName($CNId);

        # cache controlled name and variant for display purposes
        $NewCNArray[$CN->Name()] = $CN->Variant();
        $CN->Delete(TRUE);
    }
}    

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_NAMEADMIN);

$Submit = $HTTP_POST_VARS["Submit"];

# process selected controlled names
ProcessControlledNames();

# check for actual deletion
if ($Submit == "Confirm Delete Values")
{
    ConfirmDeleteValues();
}
else if ($Submit == "Delete Checked Values")
{
    DeleteCheckedValues();
}
else if ($Submit == "Update Checked Values")
{
    UpdateCheckedValues();
}
else if ($Submit == "Cancel")
{
    PrintAutoRefreshPage("Edit Controlled Names", 
                            "SPT--EditControlledName.php");
    exit;
}

PageTitle("Edit Controlled Name Complete");
$NavDirCorrection = "../";
include("include/SPT--StandardHtmlPageLoad.php");


?>
