<?PHP
#
#   FILE:  SPT--AccessPreferencesDetailedComplete.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   OPTIONAL FUNCTIONS:
#
#   FORM FIELDS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("Accessibility Preferences Saved");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# if user is logged in and came here from AccessPreferencesDetailed OR
# AccessPreferences with all options turned off
if ($User->IsLoggedIn() && 
        (isset($HTTP_POST_VARS["Submit"]) && 
        $HTTP_POST_VARS["Submit"] == "Save Preferences") ||
        $Session->Get("Submit") == "Continue")
{
    # for the following values that allow custom values, allow the
    # user to just enter a new custom value, or select a new value from
    # the option list
    # whatever has changed takes precedence, EG:
    # if the old values were "custom" and "MyFont"
    # and the new values are "Arial" and "MyFont"
    # then the value saved would be "Arial".
    # Or, if the old values were "Arial" and "" and the new values
    # are "Arial" and "MyFont" then the value saved would be "MyFont".

    # if new custom font size specified
    if (isset($HTTP_POST_VARS["F_FontSizeCustom"])
            && ($HTTP_POST_VARS["F_FontSizeCustom"] > 0)
            && ($HTTP_POST_VARS["F_FontSizeCustom"] != $User->PrefFontSize()))
    {
        # set font size to specified custom value
        $User->PrefFontSize($HTTP_POST_VARS["F_FontSizeCustom"]);
    }
    # else if font size specified
    elseif (isset($HTTP_POST_VARS["F_FontSize"]) && ($HTTP_POST_VARS["F_FontSize"] > 0))
    {
        # set font size to specified value
        $User->PrefFontSize($HTTP_POST_VARS["F_FontSize"]);
    }
    # else set to default
    else
    {
        $User->PrefFontSize(0);
    }

    # if plausible custom font face specified
    if (isset($HTTP_POST_VARS["F_FontFaceCustom"])
                && strlen($HTTP_POST_VARS["F_FontFaceCustom"])
                && $HTTP_POST_VARS["F_FontFaceCustom"] != "Enter a Font Name"
                && ($HTTP_POST_VARS["F_FontFace"] == $User->PrefFontTypeFace()
                    || $HTTP_POST_VARS["F_FontFace"] == "custom"))
    {
        # set font type face to specified custom value
        $User->PrefFontTypeFace($HTTP_POST_VARS["F_FontFaceCustom"]);
    }
    # else if font type face specified
    elseif (isset($HTTP_POST_VARS["F_FontFace"]) &&
        $HTTP_POST_VARS["F_FontFace"] != "custom")
    {
        $User->PrefFontTypeFace($HTTP_POST_VARS["F_FontFace"]);
    }
    # else set to default
    else
    {
        $User->PrefFontTypeFace("");
    }

    # if plausible custom font color specified
    if (isset($HTTP_POST_VARS["F_FontColorCustom"])
                && ($HTTP_POST_VARS["F_FontColorCustom"] != "Enter a Font Color")
                && strlen($HTTP_POST_VARS["F_FontColorCustom"])
                && ($HTTP_POST_VARS["F_FontColor"] == $User->PrefFontColor()
                    || $HTTP_POST_VARS["F_FontColor"] == "custom"))
    {
        # set font color to specified custom value
        $User->PrefFontColor($HTTP_POST_VARS["F_FontColorCustom"]);
    }
    # else if font color specified
    elseif (isset($HTTP_POST_VARS["F_FontColor"]) &&
        $HTTP_POST_VARS["F_FontColor"] != "custom")
    {
        # set font color to specified value
        $User->PrefFontColor($HTTP_POST_VARS["F_FontColor"]);
    }
    # else set to default
    else
    {
        $User->PrefFontColor("");
    }

    # if plausible custom background color specified
    if (isset($HTTP_POST_VARS["F_BackgroundColorCustom"])
            && ($HTTP_POST_VARS["F_BackgroundColorCustom"] !="Enter a Background Color")
            && strlen($HTTP_POST_VARS["F_BackgroundColorCustom"])
            && ($HTTP_POST_VARS["F_BackgroundColor"] == $User->PrefBackgroundColor()
                || $HTTP_POST_VARS["F_BackgroundColor"] == "custom")) 
    {
        # set background color to specified custom value
        $User->PrefBackgroundColor($HTTP_POST_VARS["F_BackgroundColorCustom"]);
    }
    # else if background color specified
    elseif (isset($HTTP_POST_VARS["F_BackgroundColor"]) &&
        $HTTP_POST_VARS["F_BackgroundColor"] != "custom")
    {
        # set background color to specified value
        $User->PrefBackgroundColor($HTTP_POST_VARS["F_BackgroundColor"]);
    }
    # else set to default
    else
    {
        $User->PrefBackgroundColor("");
    }

    # color avoidance 
    $ColorAvoidanceFlags = 0;
    if (isset($HTTP_POST_VARS["F_AvoidRed"]))
        $ColorAvoidanceFlags |= $HTTP_POST_VARS["F_AvoidRed"];
    if (isset($HTTP_POST_VARS["F_AvoidRedGreen"]))
        $ColorAvoidanceFlags |= $HTTP_POST_VARS["F_AvoidRedGreen"];
    if (isset($HTTP_POST_VARS["F_AvoidBlueYellow"]))
        $ColorAvoidanceFlags |= $HTTP_POST_VARS["F_AvoidBlueYellow"];
    if (isset($HTTP_POST_VARS["F_AvoidGreenYellow"]))
        $ColorAvoidanceFlags |= $HTTP_POST_VARS["F_AvoidGreenYellow"];
    if (isset($HTTP_POST_VARS["F_AvoidOrange"]))
        $ColorAvoidanceFlags |= $HTTP_POST_VARS["F_AvoidOrange"];
    if (isset($HTTP_POST_VARS["F_AvoidRedBlack"]))
        $ColorAvoidanceFlags |= $HTTP_POST_VARS["F_AvoidRedBlack"];
    if (isset($HTTP_POST_VARS["F_AvoidPurpleGrey"]))
        $ColorAvoidanceFlags |= $HTTP_POST_VARS["F_AvoidPurpleGrey"];
    if (isset($HTTP_POST_VARS["F_UseMaximumContrast"]))
        $ColorAvoidanceFlags |= $HTTP_POST_VARS["F_UseMaximumContrast"];

    $User->PrefColorAvoidanceFlags($ColorAvoidanceFlags);        
   
    # Content density
    if (isset($HTTP_POST_VARS["F_ContentDensity"]))
        $User->PrefContentDensity($HTTP_POST_VARS["F_ContentDensity"]);
    else
        $User->PrefContentDensity(UIPREF_CONTENTDENSITY_NOPREFERENCE);

    # Content view
    if (isset($HTTP_POST_VARS["F_ContentViews"]))
        $User->PrefContentView($HTTP_POST_VARS["F_ContentViews"]);
    else
        $User->PrefContentView(UIPREF_CONTENTVIEW_NOPREFERENCE);

    # Audio description level
    if (isset($HTTP_POST_VARS["F_AudioDescription"]))
        $User->PrefAudioDescriptionLevel($HTTP_POST_VARS["F_AudioDescription"]);
    else
        $User->PrefAudioDescriptionLevel(UIPREF_AUDIODESCRIPTION_NONE);

    # Audio description language
    if (isset($HTTP_POST_VARS["F_AudioDescriptionLang"]))
        $User->PrefAudioDescriptionLanguage($HTTP_POST_VARS["F_AudioDescriptionLang"]);
    else
        $User->PrefAudioDescriptionLanguage("English");

    # visual description language
    if (isset($HTTP_POST_VARS["F_AltTextLang"]))
        $User->PrefVisualDescriptionLanguage($HTTP_POST_VARS["F_AltTextLang"]);
    else
        $User->PrefVisualDescriptionLanguage("English");

    # use graphic alternatives 
    if (isset($HTTP_POST_VARS["F_GraphicAlternative"]))
        $User->PrefUseGraphicAlternatives($HTTP_POST_VARS["F_GraphicAlternative"]);
    else
        $User->PrefUseGraphicAlternatives("0");

    # use sign language 
    if (isset($HTTP_POST_VARS["F_SignLanguage"]) &&
                            $HTTP_POST_VARS["F_SignLanguage"] != "None")
        $User->PrefSignLanguage($HTTP_POST_VARS["F_SignLanguage"]);
    else
        $User->PrefSignLanguage("None");

    # use captions for auditory content 
    if (isset($HTTP_POST_VARS["F_CaptionType"]) &&
                            $HTTP_POST_VARS["F_CaptionType"] != "None")
        $User->PrefCaptionType($HTTP_POST_VARS["F_CaptionType"]);
    else
        $User->PrefCaptionType(UIPREF_CAPTIONTYPE_NONE);
    
    # set caption rate for auditory content 
    if (isset($HTTP_POST_VARS["F_CaptionRate"]) &&
                            (strval(doubleval($HTTP_POST_VARS["F_CaptionRate"]))
                                == trim($HTTP_POST_VARS["F_CaptionRate"])))
        $User->PrefCaptionRate(min(max($HTTP_POST_VARS["F_CaptionRate"], 1), 300));
    else
        $User->PrefCaptionRate(120);
}
# Cancel selected
else
{
    PrintAutoRefreshPage("Home", "SPT--Home.php");
    exit;
}

include("include/SPT--StandardHtmlPageLoad.php");

?>
