
------- SYSTEM ---------------------------------------------------------------

-- system configuration
CREATE TABLE SystemConfiguration (
    TopLinkString           TEXT DEFAULT '',
    TopLinkBeginLetter      TEXT,
    TopLinkEndLetter        TEXT,
    AdminEmail              TEXT,
    PasswordMailSubject     TEXT,
    PasswordMailBody        TEXT,
    PortalName              TEXT,
    DefaultActiveUI         TEXT,
    DefaultCharacterSet     TEXT,
    NumClassesPerBrowsePage INT DEFAULT 80,
    NumColumnsPerBrowsePage INT DEFAULT 2,
    BrowsingFieldId         INT DEFAULT 27,
    NumAnnounceOnHomePage   INT DEFAULT 2,
    NumResourcesOnHomePage  INT DEFAULT 5,
    LegalNotice             TEXT,
    SearchTermsRequired     INT,
    AnnouncementsEnabled    INT DEFAULT 1,
    ForumsEnabled           INT DEFAULT 1,
    AllowMultipleUIsEnabled INT DEFAULT 0,
    ResourceLaunchesNewWindowEnabled    INT DEFAULT 1,
    UserAgentsEnabled       INT DEFAULT 0, 
    ResourceRatingsEnabled  INT DEFAULT 0, 
    ResourceCommentsEnabled INT DEFAULT 0, 
    AccessibilityWizardEnabled  INT DEFAULT 0 DEFAULT 1,
    ReleaseFlagApproved     INT DEFAULT 0,
    SearchDBEnabled         INT DEFAULT 1, 
    RecommenderDBEnabled    INT DEFAULT 1, 
    OaiIdDomain             TEXT,
    OaiIdPrefix             TEXT,
    OaiEarliestDate         TEXT,
    OaiDateGranularity      ENUM ("DATE", "DATETIME"),
    AboutText               TEXT,
    CurrentTheme            TEXT,
    ContactName             TEXT,
    ContactEmail            TEXT,
    Organization            TEXT,
    OrganizationType        TEXT,
    SiteType                TEXT,
    OkayToListSite          INT,
    LastRegisteredOn        DATETIME
);

-- user interface style configuration
CREATE TABLE UIStyleConfiguration (
    StyleName                   TEXT,
    LogoFileName                TEXT,
    LogoAltText                 TEXT,
    LogoWidth                   INT,
    LogoHeight                  INT,
    PageCenterBackground        TEXT,
    PageSideBackground          TEXT,
    SPTTableHeaderBackground    TEXT,
    MDTTableHeaderBackground    TEXT,
    TableBodyBackground         TEXT,
    ForumDarkHeaderBackground   TEXT,
    ForumLightHeaderBackground  TEXT,
    ForumBodyBackground         TEXT,
    NavBoxBackground            TEXT,
    HomeBoxBackground           TEXT
);

-- portal news items or announcements
CREATE TABLE Announcements (
    AnnouncementId          INT NOT NULL AUTO_INCREMENT,
    AnnouncementHeading     TEXT,
    AnnouncementText        TEXT,
    DatePosted              DATETIME,
    PosterId                INT,
    INDEX                   (AnnouncementId)
);

-- persistent user searches and intelligent user agents
CREATE TABLE UserSearch (
    UserId              INT NOT NULL,
    SearchId            SMALLINT NOT NULL AUTO_INCREMENT,
    SearchName          TEXT,
    SearchCat1          TEXT,
    SearchText1         TEXT,
    SearchCat2          TEXT,
    SearchText2         TEXT,
    SearchCat3          TEXT,
    SearchText3         TEXT,
    SearchCat4          TEXT,
    SearchText4         TEXT,
    DomainLimit         TEXT,
    DateLimit           TEXT,
    ResourceType        TEXT,
    Language            TEXT,
    Audience            TEXT,
    Format              TEXT,
    Display             TEXT,
    MaxRecords          TEXT,
    Frequency           TEXT,
    DateLastRun         TIMESTAMP (14),
    AddedBy             TEXT,
    LastModifiedBy      TEXT,
    ReleaseFlag         TEXT,
    CumulativeRating    TEXT,
    SearchCriteria      TEXT,
    INDEX               (UserId),
    INDEX               (SearchId)
);

-- Rich Site Summary data export parameters
CREATE TABLE RSSConfiguration(
    EntriesToPublish        INT,
    ChannelTitle            TEXT,
    ChannelDescription      TEXT,
    ImageUrl                TEXT,
    ImageTitle              TEXT,
    ImageLink               TEXT,
    ImageHeight             INT,
    ImageWidth              INT,
    ImageDescription        TEXT,
    Language                TEXT,
    Copyright               TEXT,
    ManagingEditor          TEXT,
    Webmaster               TEXT,
    PicsRating              TEXT
);

-- add additional fields to user records
ALTER TABLE APUsers ADD COLUMN ActiveUI TEXT;
ALTER TABLE APUsers ADD COLUMN BrowsingFieldId INT;
ALTER TABLE APUsers ADD COLUMN RecordsPerPage INT DEFAULT 5;

-- UI / accessibility user preferences
CREATE TABLE UserUIPreferences(
    UserId                      INT NOT NULL,
    FontSize                    INT,
    FontTypeFace                TEXT,
    FontColor                   TEXT,
    BackgroundColor             TEXT,
    ColorAvoidanceFlags         INT,
    ContentDensity              INT,
    ContentView                 INT,
    AudioDescriptionLevel       INT,
    AudioDescriptionLanguage    TEXT,
    VisualDescriptionLanguage   TEXT,
    UseGraphicAlternatives      INT,
    SignLanguage                TEXT,
    CaptionType                 INT,
    CaptionRate                 INT DEFAULT 120,
    INDEX                       (UserId)
);


------- RESOURCES AND RELATED DATA -------------------------------------------

-- resource metadata field descriptions
CREATE TABLE MetadataFields (
    FieldId                 INT NOT NULL,
    FieldName               TEXT NOT NULL,
    FieldType               ENUM("Text", "Number", "Date", "TimeStamp", "Paragraph", "Flag", "Tree", "ControlledName", "Option", "User", "Still Image"),
    Description             TEXT,
    RequiredBySPT           INT DEFAULT 0,
    Enabled                 INT DEFAULT 1,
    Optional                INT DEFAULT 1,
    Viewable                INT DEFAULT 1,
    AllowMultiple           INT DEFAULT 0,
    IncludeInKeywordSearch  INT DEFAULT 0,
    IncludeInAdvancedSearch INT DEFAULT 0,
    IncludeInRecommender    INT DEFAULT 0,
    TextFieldSize           INT,
    MaxLength               INT,
    ParagraphRows           INT,
    ParagraphCols           INT,
    DefaultValue            TEXT,
    MinValue                INT,
    MaxValue                INT,
    FlagOnLabel             TEXT,
    FlagOffLabel            TEXT,
    DateFormat              TEXT,
    DateFormatIsPerRecord   INT,
    SearchWeight            INT,
    RecommenderWeight       INT,
    MaxHeight               INT,
    MaxWidth                INT,
    MaxPreviewHeight        INT,
    MaxPreviewWidth         INT,
    MaxThumbnailHeight      INT,
    MaxThumbnailWidth       INT,
    DefaultAltText          TEXT,
    UsesQualifiers          INT DEFAULT 0,
    HasItemLevelQualifiers  INT DEFAULT 0,
    DefaultQualifier        INT,
    DateLastModified        TIMESTAMP,
    LastModifiedById        INT,
    DisplayOrderPosition    INT,
    EditingOrderPosition    INT,
    UseForOaiSets           INT DEFAULT 0,
    INDEX                   (FieldId)
);

-- field qualifiers
CREATE TABLE Qualifiers (
    QualifierId            INT NOT NULL,
    QualifierName          TEXT,
    QualifierNamespace     TEXT,
    QualifierUrl           TEXT,
    INDEX                  (QualifierId)
);

-- intersection between MetadataFields and Qualifiers
CREATE TABLE FieldQualifierInts (
    MetadataFieldId        INT NOT NULL,
    QualifierId            INT NOT NULL,
    INDEX                  (MetadataFieldId, QualifierId)
);

-- resource records
CREATE TABLE Resources (
    ResourceId              INT NOT NULL,
    Title                   TEXT,
    AlternateTitle          TEXT,
    Description             TEXT,
    Url                     TEXT,
    ReleaseFlag             INT,
    Source                  TEXT,
    Relation                TEXT,
    Coverage                TEXT,
    Rights                  TEXT,
    EmailAddress            TEXT,
    DateIssuedBegin         DATE,
    DateIssuedEnd           DATE,
    DateIssuedPrecision     INT,
    DateOfRecordCreation    DATETIME,
    DateOfRecordRelease     DATETIME,
    DateRecordCheckedBegin  DATETIME,
    DateRecordCheckedEnd    DATETIME,
    DateRecordCheckedPrecision INT,
    DateLastModified        DATETIME,
    VerificationAttempts    INT,
    AddedById               INT,
    LastModifiedById        INT,
    CumulativeRating        INT DEFAULT 0,
    Screenshot              INT,
    INDEX                   (ResourceId)
);

-- user ratings of resources
CREATE TABLE ResourceRatings (
    ResourceId              INT NOT NULL,
    UserId                  INT NOT NULL,
    DateRated               DATETIME,
    Rating                  INT,
    Comments                TEXT,
    CommentApproved         INT,
    INDEX                   (ResourceId, UserId)
);

-- controlled names (publishers, authors, etc)
CREATE TABLE ControlledNames (
    ControlledNameId        INT NOT NULL AUTO_INCREMENT,
    ControlledName          TEXT,
    FieldId                 INT,
    QualifierId             INT,
    INDEX                   (ControlledNameId)
);

-- possible variants on controlled names
CREATE TABLE VariantNames (
    ControlledNameId        INT NOT NULL,
    VariantName             TEXT,
    INDEX                   (ControlledNameId)
);

-- classifications (subjects, categories, etc)
CREATE TABLE Classifications (
    ClassificationId        INT NOT NULL AUTO_INCREMENT,
    FieldId                 INT,
    ClassificationName      TEXT,
    Depth                   INT,
    ParentId                INT,
    SegmentName             TEXT,
    ResourceCount           INT,
    LinkString              TEXT,
    QualifierId             INT,
    INDEX                   (ClassificationId)
);

-- intersection table between Resources and ControlledNames
CREATE TABLE ResourceNameInts (
    ResourceId              INT NOT NULL,
    ControlledNameId        INT NOT NULL,
    INDEX                   (ResourceId, ControlledNameId)
);

-- intersection table between Resources and Classifications
CREATE TABLE ResourceClassInts (
    ResourceId              INT NOT NULL,
    ClassificationId        INT NOT NULL,
    INDEX                   (ResourceId, ClassificationId)
);

-- image information
CREATE TABLE Images (
    ImageId                 INT NOT NULL,
    Format                  INT,
    AltText                 TEXT,
    Width                   INT,
    Height                  INT,
    PreviewWidth            INT,
    PreviewHeight           INT,
    ThumbnailWidth          INT,
    ThumbnailHeight         INT,
    INDEX                   (ImageId)
);


------- FORUMS ---------------------------------------------------------------

-- forums (top level of forum content hierarchy)
CREATE TABLE Forums (
    ForumId                 INT NOT NULL AUTO_INCREMENT,
    ForumName               TEXT,
    ForumDescription        TEXT,
    TopicCount              INT,
    MessageCount            INT,
    ModeratorId             INT,
    INDEX                   (ForumId)
);

-- topics within forums (second level of forum content hierarchy)
-- also:  resource annotation topics
CREATE TABLE Topics (
    TopicId                 INT NOT NULL AUTO_INCREMENT,
    ForumId                 INT NOT NULL,
    CreatorId               INT,
    DateCreated             DATETIME,
    TopicName               TEXT,
    ViewCount               INT,
    MessageCount            INT,
    INDEX                   (TopicId, ForumId)
);

-- messages within forum topics (lowest level of forum content hierarchy)
CREATE TABLE Messages (
    MessageId               INT NOT NULL AUTO_INCREMENT,
    ParentId                INT NOT NULL,
    ParentType              INT NOT NULL,
    DatePosted              DATETIME,
    PosterId                INT,
    Subject                 TEXT,
    Body                    TEXT,
    INDEX                   (MessageId, ParentId)
);

-- resource searches performed by users or set up for use with user agents
CREATE TABLE Searches (
    SearchId                INT NOT NULL AUTO_INCREMENT,
    UserId                  INT NOT NULL,
    DateLastRun             DATETIME,
    Keywords                TEXT,
    RunInterval             INT,
    INDEX                   (SearchId)
);


------- RECOMMENDER SYSTEM ---------------------------------------------------

-- correlation values for recommender system
CREATE TABLE RecContentCorrelations(
    ItemIdA                 INT NOT NULL,
    ItemIdB                 INT NOT NULL,
    Correlation             SMALLINT NOT NULL,
    INDEX                   (ItemIdA, ItemIdB)
);


------- OAI EXPORT -----------------------------------------------------------

-- OAI formats table 
CREATE TABLE OAIFormats(
    FormatId        INT NOT NULL AUTO_INCREMENT,
    FormatName      TEXT,
    TagName         TEXT,
    SchemaLocation  TEXT,
    INDEX           (FormatId)
);

-- OAI format namespaces table
CREATE TABLE OAIFormatNamespaces(
    FormatId        INT NOT NULL,
    NamespaceName   TEXT,
    NamespaceURI    TEXT,
    INDEX           (FormatId)
);

-- OAI field mappings table 
CREATE TABLE OAIFieldMappings(
    FormatName          TEXT NOT NULL,
    SPTFieldId          INT NOT NULL,
    OAIFieldName        TEXT,
    INDEX               (SPTFieldId)
);

-- OAI qualifier mappings table 
CREATE TABLE OAIQualifierMappings(
    FormatName          TEXT NOT NULL,
    SPTQualifierId      INT NOT NULL,
    OAIQualifierName    TEXT,
    INDEX               (SPTQualifierId)
);

